/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.infinitearrow;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends Entity {
    private static final String INFINITY_TAG = "mafishcrossbow_source_has_infinity";
    @Shadow
    private BlockState blockState;

    @Shadow
    public abstract BlockState getBlockState();

    public FallingBlockEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="TAIL")})
    private void onInit(Level level, double x, double y, double z, BlockState blockState, CallbackInfo ci) {
        BlockPos blockPos;
        if (!level.isClientSide() && TemporaryBlockTracker.isTemporary((LevelReader)level, blockPos = BlockPos.containing((double)x, (double)y, (double)z))) {
            this.getPersistentData().putBoolean(INFINITY_TAG, true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.level().isClientSide() && this.hasInfinitySource()) {
            this.getPersistentData().putBoolean("mafishcrossbow_no_drop", true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")})
    private void beforeBlockPlace(CallbackInfo ci) {
        FallingBlockEntity self = (FallingBlockEntity)this;
        if (!this.level().isClientSide() && this.hasInfinitySource()) {
            BlockPos pos = self.blockPosition();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.scheduleTick(pos, this.getBlockState().getBlock(), 1);
                TemporaryBlockTracker.markTemporary(this.level(), pos, 400);
            }
        }
    }

    @Inject(method={"callOnBrokenAfterFall"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventInfinityBrokenCall(Block block, BlockPos pos, CallbackInfo ci) {
        if (this.hasInfinitySource()) {
            ci.cancel();
        }
    }

    private boolean hasInfinitySource() {
        return this.getPersistentData().getBooleanOr(INFINITY_TAG, false);
    }
}

