/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.infinity;

import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.crossbowoverload.OverloadHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void init2(Level p_40920_, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack crossbow = player.getItemInHand(hand);
        boolean hasInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, crossbow) > 0;
        boolean isCreative = player.isCreative();
        if (!CrossbowItem.isCharged((ItemStack)crossbow) && player.getOffhandItem().isEmpty() && (hasInfinity || isCreative) && crossbow.has(ModDataConponents.LAST_SHOT_PROJECTILE)) {
            player.startUsingItem(hand);
            cir.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Inject(method={"tryLoadProjectiles"}, at={@At(value="HEAD")}, cancellable=true)
    private static void init3(LivingEntity shooter, ItemStack crossbowStack, CallbackInfoReturnable<Boolean> cir) {
        int i;
        Player player;
        ItemStack offhand;
        Player player2;
        boolean isCreative;
        if (CrossbowItem.isCharged((ItemStack)crossbowStack)) {
            return;
        }
        int infinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, crossbowStack);
        int multishot = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.MULTISHOT, crossbowStack);
        int shotCount = 1 + multishot * 2;
        boolean bl = isCreative = shooter instanceof Player && (player2 = (Player)shooter).isCreative();
        if (infinity <= 0 && !isCreative) {
            return;
        }
        ArrayList<ItemStack> projectiles = null;
        if (shooter instanceof Player && !(offhand = (player = (Player)shooter).getOffhandItem()).isEmpty()) {
            BlockItem blockItem;
            Item item = offhand.getItem();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock) {
                return;
            }
            projectiles = new ArrayList<ItemStack>();
            for (i = 0; i < shotCount; ++i) {
                projectiles.add(offhand.copy());
            }
        }
        if (projectiles == null && crossbowStack.has(ModDataConponents.LAST_SHOT_PROJECTILE)) {
            List saved = (List)crossbowStack.get(ModDataConponents.LAST_SHOT_PROJECTILE);
            List existingEnchantments = (List)crossbowStack.get(ModDataConponents.PROJECTILE_ENCHANTMENTS.get());
            if (saved != null && !saved.isEmpty()) {
                projectiles = new ArrayList();
                for (i = 0; i < shotCount; ++i) {
                    projectiles.add(((ItemStack)saved.get(i % saved.size())).copy());
                }
                if (existingEnchantments == null || !existingEnchantments.isEmpty()) {
                    // empty if block
                }
            }
        }
        if (projectiles != null && !projectiles.isEmpty()) {
            if (OverloadHandler.mafishcrossbow$isItemStackOversized((List<ItemStack>)projectiles, shooter)) {
                OverloadHandler.mafishcrossbow$addBlackHoleInstead(shooter, crossbowStack, (ItemStack)projectiles.getFirst());
                cir.setReturnValue((Object)true);
                return;
            }
            crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)projectiles));
            cir.setReturnValue((Object)true);
        }
    }
}

