/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.intangible;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.intangible.IntangibleHelper;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class}, priority=900)
public abstract class ProjectileIntangibleMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectileIntangibleMixin.class);
    @Unique
    private boolean mafishcrossbow$intangibleLogged = false;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void mafishcrossbow$intangibleProjectileTick(CallbackInfo ci) {
        Projectile projectile = (Projectile)this;
        if (projectile instanceof AbstractArrow || projectile instanceof ThrowableProjectile) {
            return;
        }
        if (IntangibleHelper.hasIntangible(projectile.getPersistentData()) && !projectile.noPhysics) {
            projectile.noPhysics = true;
            if (!this.mafishcrossbow$intangibleLogged) {
                LOGGER.info("Intangible: Enabled noPhysics for projectile {} (type: {})", (Object)projectile.getId(), (Object)projectile.getType().toString());
                this.mafishcrossbow$intangibleLogged = true;
            }
        }
    }
}

