/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.main.crossbowoverload;

import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.crossbowoverload.OverloadHandler;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    @Inject(method={"tryLoadProjectiles"}, at={@At(value="HEAD")}, cancellable=true)
    private static void maf$tryLoadProjectiles(LivingEntity shooter, ItemStack crossbowStack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack ammo;
        ItemContainerContents container;
        BlockItem blockItem;
        Item item2;
        Player player;
        ItemStack offhand;
        if (CrossbowItem.isCharged((ItemStack)crossbowStack)) {
            return;
        }
        if (shooter instanceof Player && !(offhand = (player = (Player)shooter).getOffhandItem()).isEmpty() && (item2 = offhand.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item2).getBlock() instanceof ShulkerBoxBlock && (container = (ItemContainerContents)offhand.get(DataComponents.CONTAINER)) != null) {
            ArrayList items = new ArrayList();
            container.stream().forEach(item -> {
                if (!item.isEmpty()) {
                    items.add(item);
                }
            });
            if (!items.isEmpty()) {
                int currentIndex = (Integer)crossbowStack.getOrDefault(ModDataConponents.SHULKER_BOX_INDEX.get(), (Object)0);
                currentIndex %= items.size();
                int multishot = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.MULTISHOT, crossbowStack);
                int shotCount = 1 + multishot * 2;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                ArrayList<Integer> usedIndices = new ArrayList<Integer>();
                boolean hasInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, crossbowStack) > 0;
                boolean isCreative = player.isCreative();
                if (hasInfinity || isCreative) {
                    for (i = 0; i < shotCount; ++i) {
                        idx = (currentIndex + i) % items.size();
                        projectile = ((ItemStack)items.get(idx)).copy();
                        projectile.setCount(1);
                        list.add(projectile);
                    }
                    crossbowStack.set(ModDataConponents.SHULKER_BOX_INDEX.get(), (Object)((currentIndex + 1) % items.size()));
                } else {
                    for (i = 0; i < shotCount; ++i) {
                        idx = i % items.size();
                        projectile = ((ItemStack)items.get(idx)).copy();
                        projectile.setCount(1);
                        list.add(projectile);
                        if (usedIndices.contains(idx)) continue;
                        usedIndices.add(idx);
                    }
                }
                if (OverloadHandler.mafishcrossbow$isItemStackOversized(list, shooter)) {
                    OverloadHandler.mafishcrossbow$addBlackHoleInstead(shooter, crossbowStack, (ItemStack)items.get(0));
                    cir.setReturnValue((Object)true);
                    return;
                }
                crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(list));
                if (!hasInfinity && !isCreative) {
                    ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                    for (int i = 0; i < items.size(); ++i) {
                        ItemStack item3 = ((ItemStack)items.get(i)).copy();
                        if (usedIndices.contains(i)) {
                            item3.shrink(1);
                        }
                        if (item3.isEmpty()) continue;
                        newItems.add(item3);
                    }
                    offhand.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(newItems));
                }
                cir.setReturnValue((Object)true);
                return;
            }
        }
        if ((ammo = shooter.getProjectile(crossbowStack)).isEmpty()) {
            return;
        }
        int multishot = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.MULTISHOT, crossbowStack);
        int shotCount = 1 + multishot * 2;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < shotCount; ++i) {
            list.add(ammo.copy());
        }
        if (OverloadHandler.mafishcrossbow$isItemStackOversized(list, shooter)) {
            OverloadHandler.mafishcrossbow$addBlackHoleInstead(shooter, crossbowStack, ammo);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"performShooting"}, at={@At(value="TAIL")})
    private void maf$clearVoidLoreAfterFiring(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, float velocity, float inaccuracy, @Nullable LivingEntity target, CallbackInfo ci) {
        ItemLore lore;
        if (weapon.has(ModDataConponents.VOID_DEPTH.get())) {
            weapon.set(ModDataConponents.VOID_DEPTH, (Object)0);
        }
        if (weapon.has(DataComponents.LORE) && (lore = (ItemLore)weapon.get(DataComponents.LORE)).lines().size() == 1 && ((Component)lore.lines().get(0)).getString().contains(Component.translatable((String)"tooltip.mafishcrossbow.void_depth", (Object[])new Object[]{""}).getString().replace(" ", ""))) {
            weapon.remove(DataComponents.LORE);
        }
    }
}

