/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.main.totemfield;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemFieldProtection(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        CompoundTag tag = entity.getPersistentData();
        if (tag.getBooleanOr("TotemFieldProtection", false)) {
            tag.remove("TotemFieldProtection");
            entity.setHealth(1.0f);
            entity.removeAllEffects();
            entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, SoundSource.NEUTRAL, 0.7f, 1.0f);
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, entity.getX(), entity.getY() + 1.0, entity.getZ(), 30, 0.5, 1.0, 0.5, 0.1);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entity.getX(), entity.getY() + 0.5, entity.getZ(), 20, 0.3, 0.5, 0.3, 0.05);
            }
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updateTotemFieldProtection(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        CompoundTag tag = entity.getPersistentData();
        if (tag.contains("TotemFieldTicks")) {
            int ticks = tag.getIntOr("TotemFieldTicks", -1);
            if (ticks > 0) {
                tag.putInt("TotemFieldTicks", ticks - 1);
            } else {
                tag.remove("TotemFieldTicks");
                tag.remove("TotemFieldProtection");
                entity.setGlowingTag(false);
            }
        }
    }
}

