/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.custom.CustomFallingBlockEntity;
import com.mafuyu33.mafishcrossbow.entity.custom.EntityProjectileShell;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockItemProjectileStrategy
implements CrossbowProjectileStrategy {
    @Override
    public Projectile tryHandle(Level level, ShooterContext context, ItemStack weapon, ItemStack ammo) {
        Block block = Block.byItem((Item)ammo.getItem());
        if (block != Blocks.AIR) {
            BlockState blockState = block.defaultBlockState();
            CustomFallingBlockEntity falling = new CustomFallingBlockEntity((EntityType<? extends CustomFallingBlockEntity>)((EntityType)ModEntities.CUSTOM_FALLING_BLOCK.get()), level);
            BlockState mainState = blockState;
            BlockState otherState = null;
            if (block instanceof DoorBlock && blockState.hasProperty((Property)BlockStateProperties.HALF)) {
                mainState = (BlockState)blockState.setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM);
                otherState = (BlockState)blockState.setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP);
            } else if (blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                mainState = (BlockState)blockState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER);
                otherState = (BlockState)blockState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
            } else if (blockState.hasProperty((Property)BlockStateProperties.BED_PART)) {
                mainState = (BlockState)blockState.setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT);
                otherState = (BlockState)blockState.setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD);
                if (mainState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    Direction facing = context.getShooter() != null ? context.getShooter().getDirection() : Direction.NORTH;
                    mainState = (BlockState)mainState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                    otherState = (BlockState)otherState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                }
            }
            falling.blockState = mainState;
            falling.setOtherHalfState(otherState);
            falling.setHurtsEntities(50.0f, 10);
            if (mainState.hasBlockEntity()) {
                if (block instanceof ShulkerBoxBlock) {
                    ItemContainerContents containerContents = (ItemContainerContents)ammo.get(DataComponents.CONTAINER);
                    if (containerContents != null) {
                        falling.blockData = new CompoundTag();
                        ListTag itemsTag = new ListTag();
                        for (int i = 0; i < containerContents.getSlots(); ++i) {
                            ItemStack item = containerContents.getStackInSlot(i);
                            if (item.isEmpty()) continue;
                            CompoundTag itemTag = new CompoundTag();
                            itemTag.putByte("Slot", (byte)i);
                            DataResult encoded = ItemStack.MAP_CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)item);
                            encoded.resultOrPartial(System.err::println).ifPresent(nbt -> {
                                if (nbt instanceof CompoundTag) {
                                    CompoundTag compoundTag = (CompoundTag)nbt;
                                    itemTag.merge(compoundTag);
                                }
                            });
                            itemsTag.add((Object)itemTag);
                        }
                        falling.blockData.put("Items", (Tag)itemsTag);
                        System.out.println("[Strategy] Saved shulker box contents: " + containerContents.getSlots() + " slots");
                    }
                } else {
                    CustomData blockEntityData = (CustomData)ammo.get(DataComponents.BLOCK_ENTITY_DATA);
                    if (blockEntityData != null) {
                        falling.blockData = blockEntityData.copyTag();
                        System.out.println("[Strategy] Found BlockEntityData for " + String.valueOf(mainState.getBlock()));
                    }
                }
            }
            ModifierManager.applyTagModifier((Entity)falling, weapon, ammo, context);
            EntityProjectileShell<CustomFallingBlockEntity> shell = new EntityProjectileShell<CustomFallingBlockEntity>((EntityType)ModEntities.PROJECTILE_SHELL.get(), level, falling);
            shell.setOwner((Entity)context.getShooter());
            shell.setPos(context.getPosition());
            shell.setDeltaMovement(context.getLookDirection().scale(1.5));
            return shell;
        }
        return null;
    }
}

