/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.custom.EntityProjectileShell;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BoatItemProjectileStrategy
implements CrossbowProjectileStrategy {
    @Override
    public Projectile tryHandle(Level level, ShooterContext context, ItemStack weapon, ItemStack ammo) {
        Item item = ammo.getItem();
        if (item instanceof BoatItem) {
            BoatItem boatItem = (BoatItem)item;
            EntityType entityType = boatItem.entityType;
            AbstractBoat boat = (AbstractBoat)entityType.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            if (boat != null) {
                Vec3 look = context.getLookDirection();
                Vec3 normalizedLook = look.normalize();
                Vec3 pos = context.getPosition().add(normalizedLook.scale(2.0));
                boat.setPos(pos.x, pos.y, pos.z);
                boat.setDeltaMovement(normalizedLook.scale(1.5));
                float yaw = context.getShooter() != null ? context.getShooter().getYRot() : 0.0f;
                boat.setYRot(Mth.wrapDegrees((float)(yaw - 90.0f)));
                ModifierManager.applyTagModifier((Entity)boat, weapon, ammo, context);
                EntityProjectileShell<AbstractBoat> shell = new EntityProjectileShell<AbstractBoat>((EntityType)ModEntities.PROJECTILE_SHELL.get(), level, boat);
                shell.setOwner((Entity)context.getShooter());
                shell.setPos(pos);
                shell.setDeltaMovement(normalizedLook.scale(1.5));
                return shell;
            }
        }
        return null;
    }
}

