/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.custom.EntityProjectileShell;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class TntProjectileStrategy
implements CrossbowProjectileStrategy {
    @Override
    public Projectile tryHandle(Level level, ShooterContext context, ItemStack weapon, ItemStack ammo) {
        if (ammo.is(Items.TNT)) {
            PrimedTnt primedTnt = new PrimedTnt(level, context.getPosition().x, context.getPosition().y, context.getPosition().z, context.getShooter());
            int baseFuse = 80;
            int boreBurstLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BORE_BURST, weapon);
            if (boreBurstLevel > 0) {
                primedTnt.setFuse(1);
            } else {
                int increaseLifetimeLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.INCREASE_LIFETIME, weapon);
                int decreaseLifetimeLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.DECREASE_LIFETIME, weapon);
                int fuse = baseFuse;
                if (increaseLifetimeLevel > 0) {
                    fuse = (int)((double)fuse * (1.0 + 0.3 * (double)increaseLifetimeLevel));
                }
                if (decreaseLifetimeLevel > 0) {
                    fuse = (int)((double)fuse * (1.0 - 0.3 * (double)decreaseLifetimeLevel));
                    fuse = Math.max(1, fuse);
                }
                primedTnt.setFuse(fuse);
            }
            ModifierManager.applyTagModifier((Entity)primedTnt, weapon, ammo, context);
            EntityProjectileShell<PrimedTnt> shell = new EntityProjectileShell<PrimedTnt>((EntityType)ModEntities.PROJECTILE_SHELL.get(), level, primedTnt);
            shell.setOwner((Entity)context.getShooter());
            shell.setPos(context.getPosition());
            shell.setDeltaMovement(context.getLookDirection().scale(1.5));
            return shell;
        }
        return null;
    }
}

