/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.vanillaprojectilelifetime;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;

public class VanillaProjectileLifetimeHelper {
    private static final String TAG_TOTAL_LIFETIME = "mafishcrossbow_total_lifetime";
    private static final int DEFAULT_MAX_LIFETIME = 1200;

    public static boolean tickAndCheckLifetime(Projectile projectile) {
        if (projectile.level().isClientSide()) {
            return false;
        }
        CompoundTag data = projectile.getPersistentData();
        int totalLifetime = data.getIntOr(TAG_TOTAL_LIFETIME, 0);
        data.putInt(TAG_TOTAL_LIFETIME, ++totalLifetime);
        int modifiedMaxLifetime = 1200;
        modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)projectile, modifiedMaxLifetime, data);
        modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)projectile, modifiedMaxLifetime, data);
        return totalLifetime > modifiedMaxLifetime;
    }

    public static boolean hasInfinitySource(Projectile projectile) {
        return InfinityHelper.hasInfinitySource(projectile);
    }

    public static void resetLifetime(Projectile projectile) {
        projectile.getPersistentData().remove(TAG_TOTAL_LIFETIME);
    }
}

