/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.damage;

import com.mafuyu33.mafishcrossbow.network.DamageScalePacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;

public class DamageScaleManager {
    private static final Map<Integer, Float> entityDamageScales = new ConcurrentHashMap<Integer, Float>();

    public static void updateDamageScale(Entity entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        CompoundTag data = entity.getPersistentData();
        int increaseLevel = data.getIntOr("mafishcrossbow_increasedamage", 0);
        int decreaseLevel = data.getIntOr("mafishcrossbow_decreasedamage", 0);
        float scale = 1.0f;
        if (increaseLevel > 0) {
            scale *= 1.0f + 0.5f * (float)increaseLevel;
        }
        if (decreaseLevel > 0) {
            if (decreaseLevel >= 81) {
                scale *= 0.1f;
            } else {
                float progress = (float)decreaseLevel / 81.0f;
                scale *= 1.0f - 0.9f * (float)Math.pow(progress, 0.178);
            }
        }
        if (Math.abs(scale - 1.0f) > 0.001f) {
            entityDamageScales.put(entity.getId(), Float.valueOf(scale));
        } else {
            entityDamageScales.remove(entity.getId());
        }
        if (entity.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new DamageScalePacket(entity.getId(), scale), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static float getDamageScale(int entityId) {
        return entityDamageScales.getOrDefault(entityId, Float.valueOf(1.0f)).floatValue();
    }

    public static void setScale(int entityId, float scale) {
        if (Math.abs(scale - 1.0f) > 0.001f) {
            entityDamageScales.put(entityId, Float.valueOf(scale));
        } else {
            entityDamageScales.remove(entityId);
        }
    }

    public static void clearScale(int entityId) {
        entityDamageScales.remove(entityId);
    }

    public static void clearAll() {
        entityDamageScales.clear();
    }
}

