/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.badluckofsea;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class BadLuckOfSeaHelper {
    public static void update(Entity self, CompoundTag tag) {
        BlockPos blockPos;
        Level world;
        FluidState fluidState;
        if (!tag.contains("mafishcrossbow_bad_luck_of_sea") || self.level().isClientSide()) {
            return;
        }
        int lvl = tag.getIntOr("mafishcrossbow_bad_luck_of_sea", 0);
        if (lvl > 0 && (fluidState = (world = self.level()).getFluidState(blockPos = self.blockPosition())).is(FluidTags.WATER)) {
            BlockPos closestNonLiquidBlockPos = null;
            double closestDistanceSq = Double.MAX_VALUE;
            for (int xOffset = -20; xOffset <= 19; ++xOffset) {
                for (int zOffset = -20; zOffset <= 19; ++zOffset) {
                    double distanceSq;
                    BlockPos currentPos = blockPos.offset(xOffset, 0, zOffset);
                    FluidState fluidState1 = world.getFluidState(currentPos);
                    if (fluidState1.is(FluidTags.WATER) || !((distanceSq = self.distanceToSqr(Vec3.atCenterOf((Vec3i)currentPos))) < closestDistanceSq)) continue;
                    closestDistanceSq = distanceSq;
                    closestNonLiquidBlockPos = currentPos;
                }
            }
            if (closestNonLiquidBlockPos != null) {
                Vec3 direction = Vec3.atCenterOf(closestNonLiquidBlockPos).subtract(self.position()).normalize();
                double speed = 0.5;
                Vec3 velocity = direction.scale(speed);
                self.push(0.0, 1.0, 0.0);
                self.addDeltaMovement(velocity);
                self.hurtMarked = true;
            }
        }
    }
}

