/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.bounce;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.entity.custom.AnyProjectile;
import com.mafuyu33.mafishcrossbow.entity.custom.BundleProjectile;
import com.mafuyu33.mafishcrossbow.entity.custom.FiredCrossbowProjectile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class BounceHelper {
    private static final ProblemReporter NO_OP = new ProblemReporter(){

        public void report(ProblemReporter.Problem problem) {
        }

        public ProblemReporter forChild(ProblemReporter.PathElement path) {
            return this;
        }
    };

    public static boolean bounceWithCopy(Entity self, CompoundTag tag, BlockHitResult hit) {
        if (self.level().isClientSide) {
            return false;
        }
        if (!tag.contains("mafishcrossbow_bounceLeft") || self.level().isClientSide()) {
            return false;
        }
        int lvl = tag.getIntOr("mafishcrossbow_bounceLeft", -1);
        if (lvl <= 0) {
            return false;
        }
        return BounceHelper.bounceWithDirectCopy(self, tag, hit, lvl);
    }

    private static boolean bounceWithDirectCopy(Entity self, CompoundTag tag, BlockHitResult hit, int bounceLeft) {
        BundleProjectile bundle;
        ItemStack item;
        FiredCrossbowProjectile crossbow;
        ItemStack carried;
        CompoundTag fullNbt;
        try {
            Method saveMethod = Entity.class.getDeclaredMethod("saveAsPassenger", CompoundTag.class);
            saveMethod.setAccessible(true);
            fullNbt = (CompoundTag)saveMethod.invoke((Object)self, new CompoundTag());
            fullNbt.remove("Passengers");
        }
        catch (Exception e) {
            TagValueOutput out = TagValueOutput.createWithoutContext((ProblemReporter)NO_OP);
            self.saveWithoutId((ValueOutput)out);
            fullNbt = out.buildResult();
        }
        CompoundTag finalNbt = fullNbt;
        if (self instanceof AnyProjectile) {
            AnyProjectile any = (AnyProjectile)self;
            item = any.getItem();
            if (!item.isEmpty() && !finalNbt.contains("StoredItem")) {
                TagValueOutput anyOut = TagValueOutput.createWithoutContext((ProblemReporter)NO_OP);
                anyOut.store("StoredItem", ItemStack.CODEC, (Object)item);
                anyOut.putBoolean("ShouldDrop", true);
                CompoundTag anyResult = anyOut.buildResult();
                anyResult.keySet().forEach(key -> finalNbt.put(key, anyResult.get(key)));
            }
        } else if (self instanceof ThrowableItemProjectile) {
            ThrowableItemProjectile tip = (ThrowableItemProjectile)self;
            if (!finalNbt.contains("Item") && !(item = tip.getItem()).isEmpty()) {
                TagValueOutput tipOut = TagValueOutput.createWithoutContext((ProblemReporter)NO_OP);
                tipOut.store("Item", ItemStack.CODEC, (Object)item);
                CompoundTag tipResult = tipOut.buildResult();
                if (tipResult.contains("Item")) {
                    finalNbt.put("Item", tipResult.get("Item"));
                }
            }
        }
        if (self instanceof FiredCrossbowProjectile && !(carried = (crossbow = (FiredCrossbowProjectile)self).getCarriedCrossbow()).isEmpty()) {
            TagValueOutput crossbowOut = TagValueOutput.createWithoutContext((ProblemReporter)NO_OP);
            crossbowOut.store("CarriedCrossbow", ItemStack.CODEC, (Object)carried);
            crossbowOut.putBoolean("ShouldDrop", true);
            CompoundTag crossbowResult = crossbowOut.buildResult();
            crossbowResult.keySet().forEach(key -> finalNbt.put(key, crossbowResult.get(key)));
        }
        if (self instanceof BundleProjectile && !(item = (bundle = (BundleProjectile)self).getItem()).isEmpty()) {
            TagValueOutput bundleOut = TagValueOutput.createWithoutContext((ProblemReporter)NO_OP);
            ItemStack itemCopy = item.copyWithCount(item.getCount());
            bundleOut.store("CarriedBundle", ItemStack.CODEC, (Object)itemCopy);
            CompoundTag bundleResult = bundleOut.buildResult();
            if (bundleResult.contains("CarriedBundle")) {
                finalNbt.put("CarriedBundle", bundleResult.get("CarriedBundle"));
                finalNbt.put("Item", bundleResult.get("CarriedBundle"));
            }
            try {
                Field originalContentsField = BundleProjectile.class.getDeclaredField("originalContents");
                originalContentsField.setAccessible(true);
                BundleContents contents = (BundleContents)originalContentsField.get((Object)bundle);
                if (contents != null) {
                    TagValueOutput contentsOut = TagValueOutput.createWithoutContext((ProblemReporter)NO_OP);
                    contentsOut.store("BundleContentsBackup", BundleContents.CODEC, (Object)contents);
                    CompoundTag contentsResult = contentsOut.buildResult();
                    if (contentsResult.contains("BundleContentsBackup")) {
                        finalNbt.put("BundleContentsBackup", contentsResult.get("BundleContentsBackup"));
                    }
                }
            }
            catch (Exception e) {
                MafishCrossbow.LOGGER.error("Failed to save bundle contents: ", (Throwable)e);
            }
        }
        CompoundTag forgeData = finalNbt.getCompoundOrEmpty("NeoForgeData");
        forgeData.putInt("mafishcrossbow_bounceLeft", bounceLeft - 1);
        finalNbt.put("NeoForgeData", (Tag)forgeData);
        finalNbt.putString("id", EntityType.getKey((EntityType)self.getType()).toString());
        finalNbt.remove("UUID");
        Vec3 normal = new Vec3((double)hit.getDirection().getStepX(), (double)hit.getDirection().getStepY(), (double)hit.getDirection().getStepZ());
        Vec3 reflected = self.getDeltaMovement().subtract(normal.scale(2.0 * self.getDeltaMovement().dot(normal))).scale(0.75);
        Vec3 spawnPos = hit.getLocation().add(normal.scale(0.05));
        ValueInput in = TagValueInput.create((ProblemReporter)NO_OP, (HolderLookup.Provider)self.level().registryAccess(), (CompoundTag)finalNbt);
        EntityType type = self.getType();
        Optional maybe = EntityType.create((ValueInput)in, (Level)self.level(), (EntitySpawnReason)EntitySpawnReason.TRIGGERED);
        if (maybe.isEmpty()) {
            return false;
        }
        Entity newEntity = (Entity)maybe.get();
        newEntity.setDeltaMovement(reflected);
        newEntity.snapTo(spawnPos.x, spawnPos.y, spawnPos.z, self.getYRot(), self.getXRot());
        newEntity.hurtMarked = true;
        if (newEntity instanceof Projectile) {
            Projectile newProj = (Projectile)newEntity;
            if (self instanceof Projectile) {
                Projectile oldProj = (Projectile)self;
                newProj.setOwner(oldProj.getOwner());
            }
        }
        BounceHelper.copyEntitySpecificData(self, newEntity);
        if (self instanceof AnyProjectile) {
            AnyProjectile oldAny = (AnyProjectile)self;
            if (newEntity instanceof AnyProjectile) {
                AnyProjectile newAny = (AnyProjectile)newEntity;
                ItemStack oldItem = oldAny.getItem();
                if (!oldItem.isEmpty() && newAny.getItem().isEmpty()) {
                    MafishCrossbow.LOGGER.warn("AnyProjectile lost item during bounce, manually copying");
                    newAny.setItem(oldItem.copy());
                }
            }
        }
        self.level().addFreshEntity(newEntity);
        self.discard();
        return true;
    }

    private static void copyEntitySpecificData(Entity oldEntity, Entity newEntity) {
        if (oldEntity instanceof Projectile) {
            Projectile oldProj = (Projectile)oldEntity;
            if (newEntity instanceof Projectile) {
                ItemStack oldItem;
                Projectile newProj = (Projectile)newEntity;
                if (oldProj.getOwner() != null) {
                    newProj.setOwner(oldProj.getOwner());
                }
                if (oldProj instanceof ThrowableItemProjectile) {
                    ThrowableItemProjectile oldTip = (ThrowableItemProjectile)oldProj;
                    if (newProj instanceof ThrowableItemProjectile) {
                        ThrowableItemProjectile newTip = (ThrowableItemProjectile)newProj;
                        oldItem = oldTip.getItem();
                        ItemStack newItem = newTip.getItem();
                        if (!oldItem.isEmpty() && newItem.isEmpty()) {
                            try {
                                Method setItemMethod = newTip.getClass().getMethod("setItem", ItemStack.class);
                                setItemMethod.invoke((Object)newTip, oldItem.copy());
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    Field itemField = ThrowableItemProjectile.class.getDeclaredField("item");
                                    itemField.setAccessible(true);
                                    itemField.set(newTip, oldItem.copy());
                                }
                                catch (Exception ex) {
                                    MafishCrossbow.LOGGER.error("Failed to restore item: ", (Throwable)ex);
                                }
                            }
                            catch (Exception e) {
                                MafishCrossbow.LOGGER.error("Failed to call setItem: ", (Throwable)e);
                            }
                        }
                    }
                }
                if (oldProj instanceof FiredCrossbowProjectile) {
                    FiredCrossbowProjectile oldCrossbow = (FiredCrossbowProjectile)oldProj;
                    if (newProj instanceof FiredCrossbowProjectile) {
                        FiredCrossbowProjectile newCrossbow = (FiredCrossbowProjectile)newProj;
                        ItemStack carried = oldCrossbow.getCarriedCrossbow();
                        if (!carried.isEmpty()) {
                            ItemStack newCarried = newCrossbow.getCarriedCrossbow();
                            newCrossbow.setCarriedCrossbow(carried.copy());
                        }
                    }
                }
                if (oldProj instanceof BundleProjectile) {
                    BundleProjectile oldBundle = (BundleProjectile)oldProj;
                    if (newProj instanceof BundleProjectile) {
                        BundleProjectile newBundle = (BundleProjectile)newProj;
                        oldItem = oldBundle.getItem();
                        if (!oldItem.isEmpty()) {
                            ItemStack fullCopy = oldItem.copyWithCount(oldItem.getCount());
                            newBundle.setItem(fullCopy);
                        }
                        try {
                            Field originalContentsField = BundleProjectile.class.getDeclaredField("originalContents");
                            originalContentsField.setAccessible(true);
                            BundleContents oldContents = (BundleContents)originalContentsField.get((Object)oldBundle);
                            if (oldContents != null) {
                                originalContentsField.set((Object)newBundle, oldContents);
                            }
                        }
                        catch (Exception e) {
                            MafishCrossbow.LOGGER.error("Failed to copy originalContents: ", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

