/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.bowleft;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class BowLeftHelper {
    public static boolean hasBowLeft(CompoundTag tag) {
        return tag.contains("mafishcrossbow_bowleft") && tag.getIntOr("mafishcrossbow_bowleft", 0) > 0;
    }

    public static int getBowLeftLevel(CompoundTag tag) {
        return tag.getIntOr("mafishcrossbow_bowleft", 0);
    }

    public static void applyBowLeft(Entity entity) {
        if (!entity.level().isClientSide && BowLeftHelper.hasBowLeft(entity.getPersistentData()) && entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            Vec3 motion = projectile.getDeltaMovement();
            float yawOffset = -0.5f;
            Vec3 rotatedMotion = BowLeftHelper.rotateYaw(motion, yawOffset);
            projectile.setDeltaMovement(rotatedMotion);
        }
    }

    private static Vec3 rotateYaw(Vec3 vec, float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        double newX = vec.x * (double)cos - vec.z * (double)sin;
        double newZ = vec.x * (double)sin + vec.z * (double)cos;
        return new Vec3(newX, vec.y, newZ);
    }
}

