/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.gravity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class GravityHelper {
    public static void update(Entity self, CompoundTag tag) {
        if (!tag.contains("mafishcrossbow_gravity") || self.level().isClientSide()) {
            return;
        }
        int lvl = tag.getIntOr("mafishcrossbow_gravity", 0);
        if (lvl > 0) {
            Vec3 motion = self.getDeltaMovement();
            double currentDownwardSpeed = -motion.y;
            double maxDownwardSpeed = 3.0 + (double)lvl * 0.5;
            if (currentDownwardSpeed < maxDownwardSpeed) {
                double gravityAcceleration = 0.04 * (double)(1 + lvl);
                double newY = motion.y - gravityAcceleration;
                if (-newY > maxDownwardSpeed) {
                    newY = -maxDownwardSpeed;
                }
                self.setDeltaMovement(motion.x, newY, motion.z);
                self.hurtMarked = true;
            }
        }
    }
}

