/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class InfinityHelper {
    private static final String INFINITY_TAG = "mafishcrossbow_source_has_infinity";

    public static void applyInfinityToProjectile(Projectile projectile, ItemStack weapon) {
        if (projectile == null || weapon == null) {
            return;
        }
        if (ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, weapon) > 0) {
            projectile.getPersistentData().putBoolean(INFINITY_TAG, true);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
        }
    }

    public static boolean hasInfinitySource(Projectile projectile) {
        return projectile.getPersistentData().getBooleanOr(INFINITY_TAG, false);
    }

    public static void markAsInfinitySource(Projectile projectile) {
        projectile.getPersistentData().putBoolean(INFINITY_TAG, true);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }
}

