/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class TemporaryBlockSavedData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private List<BlockData> blocks = new ArrayList<BlockData>();
    public static final Codec<BlockData> BLOCK_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(data -> data.pos), (App)Codec.INT.fieldOf("initialTicks").forGetter(data -> data.initialTicks), (App)Codec.INT.fieldOf("remainingTicks").forGetter(data -> data.remainingTicks)).apply((Applicative)instance, BlockData::new));
    public static final Codec<TemporaryBlockSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BLOCK_DATA_CODEC.listOf().fieldOf("blocks").forGetter(data -> data.blocks)).apply((Applicative)instance, TemporaryBlockSavedData::new));
    public static final SavedDataType<TemporaryBlockSavedData> TYPE = new SavedDataType("mafishcrossbow_temporary_blocks", TemporaryBlockSavedData::new, CODEC, DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);

    public TemporaryBlockSavedData() {
        this.blocks = new ArrayList<BlockData>();
    }

    private TemporaryBlockSavedData(List<BlockData> blocks) {
        this.blocks = new ArrayList<BlockData>(blocks);
    }

    public static TemporaryBlockSavedData get(ServerLevel level) {
        return (TemporaryBlockSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public void syncFrom(List<TemporaryBlockTracker.TemporaryBlockData> trackerData) {
        this.blocks.clear();
        for (TemporaryBlockTracker.TemporaryBlockData data : trackerData) {
            this.blocks.add(new BlockData(data.pos, data.initialTicks, data.remainingTicks));
        }
        this.setDirty();
    }

    public List<BlockData> getAllBlocks() {
        return new ArrayList<BlockData>(this.blocks);
    }

    public static class BlockData {
        public final BlockPos pos;
        public final int initialTicks;
        public final int remainingTicks;

        public BlockData(BlockPos pos, int initialTicks, int remainingTicks) {
            this.pos = pos.immutable();
            this.initialTicks = initialTicks;
            this.remainingTicks = remainingTicks;
        }
    }
}

