/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockSavedData;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TemporaryBlockScheduler {
    private static final Map<ResourceKey<Level>, Integer> saveCounters = new HashMap<ResourceKey<Level>, Integer>();
    private static final int SAVE_INTERVAL = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tickTemporaryBlocks(ServerLevel level) {
        List<TemporaryBlockTracker.TemporaryBlockData> blockData = TemporaryBlockTracker.getTemporaryBlockData((ResourceKey<Level>)level.dimension());
        if (blockData == null || blockData.isEmpty()) {
            return;
        }
        ArrayList<TemporaryBlockTracker.TemporaryBlockData> toRemove = new ArrayList<TemporaryBlockTracker.TemporaryBlockData>();
        List<TemporaryBlockTracker.TemporaryBlockData> list = blockData;
        synchronized (list) {
            Iterator<TemporaryBlockTracker.TemporaryBlockData> iterator = blockData.iterator();
            while (iterator.hasNext()) {
                TemporaryBlockTracker.TemporaryBlockData data = iterator.next();
                if (!level.isLoaded(data.pos)) continue;
                if (level.getBlockState(data.pos).isAir()) {
                    int breakerId = data.pos.hashCode();
                    level.destroyBlockProgress(breakerId, data.pos, -1);
                    toRemove.add(data);
                    iterator.remove();
                    continue;
                }
                --data.remainingTicks;
                if (data.remainingTicks <= 0) {
                    TemporaryBlockScheduler.destroyTemporaryBlock(level, data.pos);
                    toRemove.add(data);
                    iterator.remove();
                    continue;
                }
                int elapsedTicks = data.initialTicks - data.remainingTicks;
                int breakProgress = Math.min(9, elapsedTicks * 10 / data.initialTicks);
                TemporaryBlockScheduler.sendBreakProgress(level, data.pos, breakProgress);
            }
        }
        for (TemporaryBlockTracker.TemporaryBlockData data : toRemove) {
            TemporaryBlockTracker.removeTemporary((Level)level, data.pos);
        }
        int counter = saveCounters.getOrDefault(level.dimension(), 0) + 1;
        saveCounters.put((ResourceKey<Level>)level.dimension(), counter);
        if (counter >= 20) {
            saveCounters.put((ResourceKey<Level>)level.dimension(), 0);
            TemporaryBlockSavedData savedData = TemporaryBlockSavedData.get(level);
            savedData.syncFrom(blockData);
        }
    }

    private static void destroyTemporaryBlock(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        int breakerId = pos.hashCode();
        level.destroyBlockProgress(breakerId, pos, -1);
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        level.destroyBlock(pos, false);
    }

    private static void sendBreakProgress(ServerLevel level, BlockPos pos, int stage) {
        int breakerId = pos.hashCode();
        level.destroyBlockProgress(breakerId, pos, Math.min(stage, 9));
    }
}

