/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockSavedData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class TemporaryBlockTracker {
    private static final Map<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>> temporaryBlocks = new ConcurrentHashMap<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>>();
    private static final Map<ResourceKey<Level>, List<TemporaryBlockData>> temporaryBlockData = new ConcurrentHashMap<ResourceKey<Level>, List<TemporaryBlockData>>();

    public static void markTemporary(Level level, BlockPos pos, int ticks) {
        if (level.isClientSide()) {
            return;
        }
        ResourceKey dimension = level.dimension();
        ChunkPos chunkPos = new ChunkPos(pos);
        temporaryBlocks.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ConcurrentHashMap()).computeIfAbsent(chunkPos, k -> ConcurrentHashMap.newKeySet()).add(pos.immutable());
        temporaryBlockData.computeIfAbsent((ResourceKey<Level>)dimension, k -> Collections.synchronizedList(new ArrayList())).add(new TemporaryBlockData(pos, ticks));
    }

    public static boolean isTemporary(LevelReader level, BlockPos pos) {
        Level l;
        if (!(level instanceof Level) || (l = (Level)level).isClientSide()) {
            return false;
        }
        ResourceKey dimension = l.dimension();
        Map<ChunkPos, Set<BlockPos>> dimensionBlocks = temporaryBlocks.get(dimension);
        if (dimensionBlocks == null) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        Set<BlockPos> chunkBlocks = dimensionBlocks.get(chunkPos);
        return chunkBlocks != null && chunkBlocks.contains(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTemporary(Level level, BlockPos pos) {
        List<TemporaryBlockData> dataList;
        Set<BlockPos> chunkBlocks;
        if (level.isClientSide()) {
            return;
        }
        ResourceKey dimension = level.dimension();
        ChunkPos chunkPos = new ChunkPos(pos);
        Map<ChunkPos, Set<BlockPos>> dimensionBlocks = temporaryBlocks.get(dimension);
        if (dimensionBlocks != null && (chunkBlocks = dimensionBlocks.get(chunkPos)) != null) {
            chunkBlocks.remove(pos);
            if (chunkBlocks.isEmpty()) {
                dimensionBlocks.remove(chunkPos);
            }
        }
        if ((dataList = temporaryBlockData.get(dimension)) != null) {
            List<TemporaryBlockData> list = dataList;
            synchronized (list) {
                dataList.removeIf(data -> data.pos.equals((Object)pos));
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int breakerId = pos.hashCode();
            serverLevel.destroyBlockProgress(breakerId, pos, -1);
        }
    }

    public static List<TemporaryBlockData> getTemporaryBlockData(ResourceKey<Level> dimension) {
        return temporaryBlockData.get(dimension);
    }

    public static void clearDimension(ResourceKey<Level> dimension) {
        temporaryBlocks.remove(dimension);
        temporaryBlockData.remove(dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRemainingTime(Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return 0;
        }
        ResourceKey dimension = level.dimension();
        List<TemporaryBlockData> dataList = temporaryBlockData.get(dimension);
        if (dataList == null) {
            return 0;
        }
        List<TemporaryBlockData> list = dataList;
        synchronized (list) {
            for (TemporaryBlockData data : dataList) {
                if (!data.pos.equals((Object)pos)) continue;
                return data.remainingTicks;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveTemporaryBlock(Level level, BlockPos from, BlockPos to) {
        if (level.isClientSide()) {
            return;
        }
        ResourceKey dimension = level.dimension();
        List<TemporaryBlockData> dataList = temporaryBlockData.get(dimension);
        TemporaryBlockData originalData = null;
        if (dataList != null) {
            List<TemporaryBlockData> list = dataList;
            synchronized (list) {
                for (TemporaryBlockData data : dataList) {
                    if (!data.pos.equals((Object)from)) continue;
                    originalData = data;
                    break;
                }
            }
        }
        if (originalData != null && originalData.remainingTicks > 0) {
            TemporaryBlockTracker.removeTemporary(level, from);
            TemporaryBlockTracker.markTemporary(level, to, originalData.remainingTicks);
        }
    }

    public static void loadFromSavedData(ServerLevel level) {
        ResourceKey dimension = level.dimension();
        TemporaryBlockSavedData savedData = TemporaryBlockSavedData.get(level);
        List<TemporaryBlockSavedData.BlockData> savedBlocks = savedData.getAllBlocks();
        if (savedBlocks.isEmpty()) {
            return;
        }
        temporaryBlocks.remove(dimension);
        temporaryBlockData.remove(dimension);
        int loadedCount = 0;
        for (TemporaryBlockSavedData.BlockData savedBlock : savedBlocks) {
            ChunkPos chunkPos = new ChunkPos(savedBlock.pos);
            temporaryBlocks.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ConcurrentHashMap()).computeIfAbsent(chunkPos, k -> ConcurrentHashMap.newKeySet()).add(savedBlock.pos.immutable());
            TemporaryBlockData data = new TemporaryBlockData(savedBlock.pos, savedBlock.initialTicks);
            data.remainingTicks = savedBlock.remainingTicks;
            temporaryBlockData.computeIfAbsent((ResourceKey<Level>)dimension, k -> Collections.synchronizedList(new ArrayList())).add(data);
            ++loadedCount;
        }
    }

    public static class TemporaryBlockData {
        public final BlockPos pos;
        public final int initialTicks;
        public int remainingTicks;

        public TemporaryBlockData(BlockPos pos, int ticks) {
            this.pos = pos.immutable();
            this.initialTicks = ticks;
            this.remainingTicks = ticks;
        }
    }
}

