/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.misfire;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.CrossbowProjectileStrategyHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.phys.Vec3;

public class MisfireHelper {
    public static void updateItemEntity(ItemEntity itemEntity) {
        if (itemEntity.level().isClientSide()) {
            return;
        }
        ItemStack stack = itemEntity.getItem();
        CompoundTag tag = itemEntity.getPersistentData();
        MisfireHelper.updateLastHolder(itemEntity, stack);
        int misfireLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.MISFIRE, stack);
        if (misfireLevel <= 0) {
            return;
        }
        boolean alreadyTriggered = tag.getBoolean("mafishcrossbow_misfire_triggered").orElse(false);
        if (itemEntity.onGround() && !alreadyTriggered) {
            tag.putBoolean("mafishcrossbow_misfire_triggered", true);
            Direction hitDirection = MisfireHelper.getHitDirection(itemEntity);
            Vec3 fireDirection = new Vec3((double)(-hitDirection.getStepX()), (double)(-hitDirection.getStepY()), (double)(-hitDirection.getStepZ()));
            LivingEntity owner = MisfireHelper.getLastHolder(itemEntity);
            if (owner == null) {
                owner = MisfireHelper.findNearestPlayer(itemEntity);
            }
            MafishCrossbow.LOGGER.info("Misfire triggered! Item: {}, Direction: {}, Owner: {}", new Object[]{stack.getItem(), fireDirection, owner != null ? owner.getName().getString() : "None"});
            if (stack.getItem() instanceof CrossbowItem) {
                MisfireHelper.fireCrossbowProjectiles(itemEntity, stack, fireDirection, owner);
                stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            } else if (stack.getItem() instanceof BundleItem) {
                MisfireHelper.fireBundleProjectiles(itemEntity, stack, fireDirection, owner);
                stack.set(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            }
        }
    }

    private static void updateLastHolder(ItemEntity itemEntity, ItemStack stack) {
        Entity thrower;
        CompoundTag itemTag = itemEntity.getPersistentData();
        if (itemEntity.getAge() < 2 && (thrower = itemEntity.getOwner()) != null) {
            itemTag.store("mafishcrossbow_last_holder", UUIDUtil.CODEC, (Object)thrower.getUUID());
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag stackTag = customData.copyTag();
        stackTag.read("mafishcrossbow_last_holder", UUIDUtil.CODEC).ifPresent(holderUuid -> itemTag.store("mafishcrossbow_last_holder", UUIDUtil.CODEC, holderUuid));
    }

    private static LivingEntity getLastHolder(ItemEntity itemEntity) {
        Entity entity;
        CompoundTag tag = itemEntity.getPersistentData();
        UUID holderUuid = tag.read("mafishcrossbow_last_holder", UUIDUtil.CODEC).orElse(null);
        if (holderUuid != null && (entity = ((ServerLevel)itemEntity.level()).getEntity(holderUuid)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    private static Player findNearestPlayer(ItemEntity itemEntity) {
        return itemEntity.level().getNearestPlayer((Entity)itemEntity, 64.0);
    }

    private static Direction getHitDirection(ItemEntity itemEntity) {
        if (itemEntity.onGround()) {
            return Direction.DOWN;
        }
        Vec3 motion = itemEntity.getDeltaMovement();
        double absX = Math.abs(motion.x);
        double absY = Math.abs(motion.y);
        double absZ = Math.abs(motion.z);
        if (absY > absX && absY > absZ) {
            return motion.y > 0.0 ? Direction.UP : Direction.DOWN;
        }
        if (absX > absZ) {
            return motion.x > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return motion.z > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    private static void fireCrossbowProjectiles(ItemEntity itemEntity, ItemStack crossbow, Vec3 direction, LivingEntity owner) {
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles == null || chargedProjectiles.isEmpty()) {
            return;
        }
        List projectiles = chargedProjectiles.getItems();
        Vec3 spawnPos = itemEntity.position().add(0.0, 0.5, 0.0);
        for (ItemStack projectileItem : projectiles) {
            StaticShooterContext context = new StaticShooterContext(spawnPos, direction, owner);
            Projectile projectile = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(itemEntity.level(), context, crossbow, projectileItem);
            if (projectile == null) continue;
            ModifierManager.applyTagModifier((Entity)projectile, crossbow, projectileItem, context);
            projectile.setPos(spawnPos);
            projectile.shoot(direction.x, direction.y, direction.z, 3.0f, 0.0f);
            itemEntity.level().addFreshEntity((Entity)projectile);
        }
    }

    private static void fireBundleProjectiles(ItemEntity itemEntity, ItemStack bundle, Vec3 direction, LivingEntity owner) {
        BundleContents bundleContents = (BundleContents)bundle.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents == null || bundleContents.isEmpty()) {
            return;
        }
        ArrayList items = new ArrayList();
        bundleContents.items().forEach(itemStack -> {
            for (int count = 0; count < itemStack.getCount(); ++count) {
                ItemStack singleItem = itemStack.copy();
                singleItem.setCount(1);
                items.add(singleItem);
            }
        });
        Vec3 spawnPos = itemEntity.position().add(0.0, 0.5, 0.0);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack projectileItem = (ItemStack)items.get(i);
            double theta = itemEntity.level().random.nextDouble() * Math.PI * 2.0;
            double phi = itemEntity.level().random.nextDouble() * Math.toRadians(75.0);
            Vec3 scatteredDirection = MisfireHelper.calculateConeDirection(direction, theta, phi);
            StaticShooterContext context = new StaticShooterContext(spawnPos, scatteredDirection, owner);
            Projectile projectile = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(itemEntity.level(), context, bundle, projectileItem);
            if (projectile == null) continue;
            ModifierManager.applyTagModifier((Entity)projectile, bundle, projectileItem, context);
            projectile.setPos(spawnPos);
            projectile.shoot(scatteredDirection.x, scatteredDirection.y, scatteredDirection.z, 0.8f, 0.0f);
            itemEntity.level().addFreshEntity((Entity)projectile);
        }
    }

    private static Vec3 calculateConeDirection(Vec3 centerAxis, double theta, double phi) {
        Vec3 axis = centerAxis.normalize();
        Vec3 perpendicular = Math.abs(axis.y) < 0.99 ? new Vec3(0.0, 1.0, 0.0).cross(axis).normalize() : new Vec3(1.0, 0.0, 0.0).cross(axis).normalize();
        Vec3 perpendicular2 = axis.cross(perpendicular).normalize();
        double sinPhi = Math.sin(phi);
        Vec3 offset = perpendicular.scale(sinPhi * Math.cos(theta)).add(perpendicular2.scale(sinPhi * Math.sin(theta)));
        return axis.scale(Math.cos(phi)).add(offset).normalize();
    }
}

