/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network;

import com.mafuyu33.mafishcrossbow.mixinhandler.damage.DamageScaleManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DamageScalePacket(int entityId, float scale) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DamageScalePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"damage_scale"));
    public static final StreamCodec<ByteBuf, DamageScalePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DamageScalePacket::entityId, (StreamCodec)ByteBufCodecs.FLOAT, DamageScalePacket::scale, DamageScalePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(DamageScalePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (packet.scale != 1.0f) {
                DamageScaleManager.setScale(packet.entityId, packet.scale);
            } else {
                DamageScaleManager.clearScale(packet.entityId);
            }
        });
    }
}

