/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.gui.EnchantmentTableMenu;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EnchantmentModifyC2SPacket(Operation operation, ResourceLocation enchantmentId, int level) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnchantmentModifyC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"enchantment_modify"));
    public static final StreamCodec<FriendlyByteBuf, EnchantmentModifyC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec(Operation.CODEC), EnchantmentModifyC2SPacket::operation, (StreamCodec)ResourceLocation.STREAM_CODEC, EnchantmentModifyC2SPacket::enchantmentId, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantmentModifyC2SPacket::level, EnchantmentModifyC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(EnchantmentModifyC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                Holder.Reference enchantmentHolder;
                ServerPlayer player = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (!(patt1$temp instanceof EnchantmentTableMenu)) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to modify enchantment but container is not EnchantmentTableMenu", (Object)player.getName().getString());
                    return;
                }
                EnchantmentTableMenu menu = (EnchantmentTableMenu)patt1$temp;
                if (!menu.stillValid((Player)player)) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to modify enchantment but menu is invalid", (Object)player.getName().getString());
                    return;
                }
                ResourceKey enchantmentKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)payload.enchantmentId());
                try {
                    enchantmentHolder = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantmentKey);
                }
                catch (Exception e) {
                    MafishCrossbow.LOGGER.warn("Invalid enchantment: {}", (Object)payload.enchantmentId());
                    return;
                }
                switch (payload.operation().ordinal()) {
                    case 0: {
                        menu.addEnchantment((Holder<Enchantment>)enchantmentHolder, payload.level());
                        break;
                    }
                    case 1: {
                        menu.removeEnchantment((Holder<Enchantment>)enchantmentHolder);
                        break;
                    }
                    case 2: {
                        menu.setEnchantmentLevel((Holder<Enchantment>)enchantmentHolder, payload.level());
                    }
                }
                menu.createResult();
            }
        });
    }

    public static enum Operation {
        ADD,
        REMOVE,
        SET_LEVEL;

        public static final Codec<Operation> CODEC;

        static {
            CODEC = Codec.INT.xmap(i -> Operation.values()[i], Enum::ordinal);
        }
    }
}

