/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.S2C;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CustomWindChargeS2CPacket
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<CustomWindChargeS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"custom_wind_charge"));
    public static final StreamCodec<FriendlyByteBuf, CustomWindChargeS2CPacket> STREAM_CODEC = CustomPacketPayload.codec(CustomWindChargeS2CPacket::write, CustomWindChargeS2CPacket::new);
    public int radius;
    public UUID uuid;

    public CustomWindChargeS2CPacket(UUID uuid, int radius) {
        this.uuid = uuid;
        this.radius = radius;
    }

    public CustomWindChargeS2CPacket(FriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        this.radius = buf.readInt();
    }

    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeUUID(this.uuid);
        pBuffer.writeInt(this.radius);
    }

    public static void handle(CustomWindChargeS2CPacket data, IPayloadContext context) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class CustomWindChargeData {
        private static final Map<UUID, Integer> dataMap = new ConcurrentHashMap<UUID, Integer>();

        public static void set(UUID newUuid, int newRadius) {
            dataMap.put(newUuid, newRadius);
        }

        public static int getRadius(UUID uuid) {
            return dataMap.getOrDefault(uuid, 0);
        }
    }
}

