/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.S2C;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record LightningPathSyncPacket(int entityId, List<Vec3> pathPoints) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LightningPathSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"lightning_path_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LightningPathSyncPacket> STREAM_CODEC = StreamCodec.of(LightningPathSyncPacket::encode, LightningPathSyncPacket::decode);

    private static void encode(RegistryFriendlyByteBuf buffer, LightningPathSyncPacket packet) {
        buffer.writeInt(packet.entityId);
        buffer.writeInt(packet.pathPoints.size());
        for (Vec3 point : packet.pathPoints) {
            buffer.writeDouble(point.x);
            buffer.writeDouble(point.y);
            buffer.writeDouble(point.z);
        }
    }

    private static LightningPathSyncPacket decode(RegistryFriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        int size = buffer.readInt();
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        for (int i = 0; i < size; ++i) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            double z = buffer.readDouble();
            points.add(new Vec3(x, y, z));
        }
        return new LightningPathSyncPacket(entityId, points);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler
    implements IPayloadHandler<LightningPathSyncPacket> {
        public void handle(LightningPathSyncPacket data, IPayloadContext context) {
        }
    }
}

