/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import org.joml.Quaternionfc;

public class CrossbowProjectileRenderer {
    public static Float debugXOffset = null;
    public static Float debugYOffset = null;
    public static Float debugZOffset = null;
    public static Float debugScale = null;
    public static Float debugRotation = null;
    public static Float debugStackSpacing = null;
    public static Float debugBlockXOffset = null;
    public static Float debugBlockYOffset = null;
    public static Float debugBlockZOffset = null;
    public static Float debugBlockScale = null;
    public static Float debugBlockRotation = null;

    public static void renderProjectiles(ItemStack crossbow, PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemRenderer itemRenderer, boolean isRightHand) {
        if (!(crossbow.getItem() instanceof CrossbowItem)) {
            return;
        }
        if (!CrossbowItem.isCharged((ItemStack)crossbow)) {
            return;
        }
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles == null || chargedProjectiles.isEmpty()) {
            return;
        }
        boolean hasNonArrowItems = false;
        for (ItemStack item : chargedProjectiles.getItems()) {
            if (item.isEmpty() || item.getItem() instanceof ArrowItem || item.getItem() == Items.FIREWORK_ROCKET) continue;
            hasNonArrowItems = true;
            break;
        }
        if (!hasNonArrowItems) {
            return;
        }
        List projectiles = chargedProjectiles.getItems();
        int projectileCount = projectiles.size();
        CrossbowProjectileRenderer.renderSingleProjectile((ItemStack)projectiles.getFirst(), poseStack, buffer, packedLight, itemRenderer, isRightHand, 0.0f);
    }

    private static void renderSingleProjectile(ItemStack projectile, PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemRenderer itemRenderer, boolean isRightHand, float multiYOffset) {
        float zOffset;
        float yOffset;
        float xOffset;
        float scale;
        if (projectile.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        boolean isBlock = projectile.getItem() instanceof BlockItem;
        if (isBlock) {
            scale = 0.56f;
            xOffset = 0.07f;
            yOffset = 0.22f;
            zOffset = 0.111f;
        } else {
            scale = 0.56f;
            xOffset = 0.07f;
            yOffset = 0.22f;
            zOffset = -0.05f;
        }
        if (isBlock) {
            if (debugBlockXOffset != null) {
                xOffset = debugBlockXOffset.floatValue();
            }
            if (debugBlockYOffset != null) {
                yOffset = debugBlockYOffset.floatValue();
            }
            if (debugBlockZOffset != null) {
                zOffset = debugBlockZOffset.floatValue();
            }
            if (debugBlockScale != null) {
                scale = debugBlockScale.floatValue();
            }
        } else {
            if (debugXOffset != null) {
                xOffset = debugXOffset.floatValue();
            }
            if (debugYOffset != null) {
                yOffset = debugYOffset.floatValue();
            }
            if (debugZOffset != null) {
                zOffset = debugZOffset.floatValue();
            }
            if (debugScale != null) {
                scale = debugScale.floatValue();
            }
        }
        if (!isRightHand) {
            xOffset = -xOffset;
        }
        poseStack.translate(xOffset, yOffset + multiYOffset, zOffset);
        poseStack.scale(scale, scale, scale);
        if (!(projectile.getItem() instanceof ArrowItem) && projectile.getItem() != Items.FIREWORK_ROCKET) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            if (!isRightHand) {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
            }
            float rotation = -34.0f;
            if (isBlock && debugBlockRotation != null) {
                rotation = debugBlockRotation.floatValue();
            } else if (!isBlock && debugRotation != null) {
                rotation = debugRotation.floatValue();
            }
            if (!isRightHand) {
                rotation = -rotation;
            }
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotation));
        }
        itemRenderer.renderStatic(projectile, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, null, 0);
        poseStack.popPose();
    }
}

