/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.phys.Vec3;

public class CrossbowScatterUtil {
    private static final Random RANDOM = new Random();

    public static List<Vec3> computeSphericalScatterDirections(Vec3 baseVec, int count, float maxYawDeg, float maxPitchDeg) {
        ArrayList<Vec3> directions = new ArrayList<Vec3>(count);
        for (int i = 0; i < count; ++i) {
            float yawOffset = (RANDOM.nextFloat() * 2.0f - 1.0f) * maxYawDeg;
            float pitchOffset = (RANDOM.nextFloat() * 2.0f - 1.0f) * maxPitchDeg;
            directions.add(CrossbowScatterUtil.rotateVectorPitchYaw(baseVec, pitchOffset, yawOffset).normalize());
        }
        return directions;
    }

    public static Vec3 rotateVectorPitchYaw(Vec3 vec, float pitchDeg, float yawDeg) {
        double pitchRad = Math.toRadians(pitchDeg);
        double yawRad = Math.toRadians(yawDeg);
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        double cosPitch = Math.cos(pitchRad);
        double sinPitch = Math.sin(pitchRad);
        double y1 = y * cosPitch - z * sinPitch;
        double z1 = y * sinPitch + z * cosPitch;
        double cosYaw = Math.cos(yawRad);
        double sinYaw = Math.sin(yawRad);
        double x2 = x * cosYaw + z1 * sinYaw;
        double z2 = -x * sinYaw + z1 * cosYaw;
        return new Vec3(x2, y1, z2);
    }
}

