/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.config;

import cn.ussshenzhou.t88.config.TConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class ConfigHelper {
    private static final File CONFIG_DIR = FMLPaths.CONFIGDIR.relative().toFile();
    private static final ConcurrentHashMap<Class<? extends TConfig>, TConfig> CACHE = new ConcurrentHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final File UNIVERSAL_CONFIG_DIR = FileUtils.getUserDirectory().toPath().resolve("MinecraftT88Config").toFile();

    private static void checkDir(File dir) {
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
    }

    private static File checkFile(TConfig config, boolean universal) {
        ConfigHelper.checkDir(universal ? UNIVERSAL_CONFIG_DIR : CONFIG_DIR);
        String configFileName = config.getClass().getSimpleName();
        Path childDir = (universal ? UNIVERSAL_CONFIG_DIR : CONFIG_DIR).toPath().resolve(config.getChildDirName());
        ConfigHelper.checkDir(childDir.toFile());
        return childDir.resolve(configFileName + ".json").toFile();
    }

    public static void loadConfig(TConfig newInstance) {
        File configFile = ConfigHelper.checkFile(newInstance, false);
        ConfigHelper.loadConfigInternal(newInstance, configFile);
    }

    public static <T extends TConfig> T getConfigRead(Class<T> configClass) {
        return (T)CACHE.get(configClass);
    }

    public static <T extends TConfig> void getConfigWrite(Class<T> configClass, Consumer<T> setter) {
        TConfig config = CACHE.get(configClass);
        setter.accept(config);
        ConfigHelper.saveConfig(config);
    }

    public static <T extends TConfig> void saveConfig(T config) {
        File configFile = ConfigHelper.checkFile(config, false);
        ConfigHelper.saveConfigInternal(config, configFile);
    }

    private static void loadConfigInternal(TConfig newInstance, File configFile) {
        try {
            if (configFile.isFile()) {
                newInstance = (TConfig)GSON.fromJson(FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8), newInstance.getClass());
            } else {
                FileUtils.write((File)configFile, (CharSequence)GSON.toJson((Object)newInstance), (Charset)StandardCharsets.UTF_8);
            }
            CACHE.put(newInstance.getClass(), newInstance);
            ConfigHelper.saveConfigInternal(newInstance, configFile);
        }
        catch (IOException ignored) {
            LogUtils.getLogger().error("Failed to load config {}. Things may not work well.", newInstance.getClass());
        }
    }

    private static <T extends TConfig> void saveConfigInternal(T config, File configFile) {
        Thread.startVirtualThread(() -> {
            try {
                FileUtils.write((File)configFile, (CharSequence)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ignored) {
                LogUtils.getLogger().error("Failed to save config {}. Things may not work well.", config.getClass());
            }
        });
    }

    public static class Universal
    extends ConfigHelper {
        public static void loadConfig(TConfig newInstance) {
            File configFile = ConfigHelper.checkFile(newInstance, true);
            ConfigHelper.loadConfigInternal(newInstance, configFile);
        }

        public static <T extends TConfig> void getConfigWrite(Class<T> configClass, Consumer<T> setter) {
            TConfig config = CACHE.get(configClass);
            setter.accept(config);
            Universal.saveConfig(config);
        }

        public static <T extends TConfig> void saveConfig(T config) {
            File configFile = ConfigHelper.checkFile(config, true);
            ConfigHelper.saveConfigInternal(config, configFile);
        }
    }
}

