/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.advanced;

import cn.ussshenzhou.t88.gui.container.TVerticalScrollContainer;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.util.LayoutHelper;
import cn.ussshenzhou.t88.gui.widegt.TCycleButton;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TSlider;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import cn.ussshenzhou.t88.util.Util;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import org.joml.Vector2i;

public class TOptionsPanel
extends TPanel {
    public final OptionContainerVertical container;
    protected int gapBetweenOptions = 4;
    protected HorizontalAlignment titleHorizontalAlignment = HorizontalAlignment.RIGHT;

    public TOptionsPanel() {
        this.container = new OptionContainerVertical();
        this.add(this.container);
    }

    public <T extends TWidget> Tuple<TOptionsPanel, T> addOption(Component title, T controller) {
        HorizontalTitledOption<T> option = new HorizontalTitledOption<T>(title, controller);
        this.container.add(option);
        return new Tuple((Object)this, controller);
    }

    public Tuple<TOptionsPanel, TSlider> addOptionSliderDouble(Component title, double minValue, double maxValue, @Nullable Component tipText, BiConsumer<TSlider, Double> responder, boolean applyValueImmediately) {
        TSlider slider = new TSlider("", minValue, maxValue, true, tipText, applyValueImmediately);
        slider.addResponder(d -> responder.accept(slider, (Double)d));
        return this.addOption(title, slider);
    }

    public Tuple<TOptionsPanel, TSlider> addOptionSliderDouble(Component title, double minValue, double maxValue, BiFunction<Component, Double, Component> textFromCaptionAndValue, @Nullable Component tipText, BiConsumer<TSlider, Double> responder, boolean applyValueImmediately) {
        TSlider slider = new TSlider("", minValue, maxValue, textFromCaptionAndValue, tipText, applyValueImmediately);
        slider.addResponder(d -> responder.accept(slider, (Double)d));
        return this.addOption(title, slider);
    }

    public Tuple<TOptionsPanel, TSlider> addOptionSliderDoubleInit(Component title, double minValue, double maxValue, @Nullable Component tipText, BiConsumer<TSlider, Double> responder, double initAbsValue, boolean applyValueImmediately) {
        Tuple<TOptionsPanel, TSlider> r = this.addOptionSliderDouble(title, minValue, maxValue, tipText, responder, applyValueImmediately);
        ((TSlider)r.getB()).setAbsValueWithoutRespond(initAbsValue);
        return r;
    }

    public Tuple<TOptionsPanel, TSlider> addOptionSliderDoubleInit(Component title, double minValue, double maxValue, BiFunction<Component, Double, Component> textFromCaptionAndValue, @Nullable Component tipText, BiConsumer<TSlider, Double> responder, double initAbsValue, boolean applyValueImmediately) {
        Tuple<TOptionsPanel, TSlider> r = this.addOptionSliderDouble(title, minValue, maxValue, textFromCaptionAndValue, tipText, responder, applyValueImmediately);
        ((TSlider)r.getB()).setAbsValueWithoutRespond(initAbsValue);
        return r;
    }

    public <E> Tuple<TOptionsPanel, TCycleButton<E>> addOptionCycleButton(Component title, List<E> entryContents, List<Consumer<TCycleButton<E>>> responders) {
        if (entryContents.size() != responders.size()) {
            throw new IllegalArgumentException(String.format("Collection %s with size %d must be the same size as collection %s with size %d.", entryContents, entryContents.size(), responders, responders.size()));
        }
        HorizontalTitledOption option = new HorizontalTitledOption(title, new TCycleButton());
        for (int i = 0; i < entryContents.size(); ++i) {
            ((TCycleButton)option.controller).addElement(entryContents.get(i), responders.get(i));
        }
        this.container.add(option);
        return new Tuple((Object)this, (Object)((TCycleButton)option.controller));
    }

    public <E> Tuple<TOptionsPanel, TCycleButton<E>> addOptionCycleButton(Component title, List<E> entryContents, Function<E, Consumer<TCycleButton<E>>> responderGenerator) {
        return this.addOptionCycleButton(title, entryContents, entryContents.stream().map(responderGenerator).toList());
    }

    public <E> Tuple<TOptionsPanel, TCycleButton<E>> addOptionCycleButtonInit(Component title, List<E> entryContents, List<Consumer<TCycleButton<E>>> responders, Predicate<TCycleButton.Entry> initializer) {
        Tuple<TOptionsPanel, TCycleButton<E>> r = this.addOptionCycleButton(title, entryContents, responders);
        ((TCycleButton)r.getB()).selectWithoutRespond(initializer);
        return r;
    }

    public <E> Tuple<TOptionsPanel, TCycleButton<E>> addOptionCycleButtonInit(Component title, List<E> entryContents, Function<E, Consumer<TCycleButton<E>>> responderGenerator, Predicate<TCycleButton.Entry> initializer) {
        Tuple<TOptionsPanel, TCycleButton<E>> r = this.addOptionCycleButton(title, entryContents, responderGenerator);
        ((TCycleButton)r.getB()).selectWithoutRespond(initializer);
        return r;
    }

    public Tuple<TOptionsPanel, OptionSplitter> addOptionSplitter(Component title) {
        OptionSplitter splitter = new OptionSplitter(title);
        this.container.add(splitter);
        return new Tuple((Object)this, (Object)splitter);
    }

    public void setGapBetweenOptions(int gapBetweenOptions) {
        this.gapBetweenOptions = gapBetweenOptions;
        this.getParentLazy().layout();
    }

    public void setTitleHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.titleHorizontalAlignment = horizontalAlignment;
        this.container.getChildren().stream().filter(t -> t instanceof HorizontalTitledOption).forEach(t -> ((HorizontalTitledOption)t).title.setHorizontalAlignment(this.titleHorizontalAlignment));
        this.container.getChildren().stream().filter(t -> t instanceof OptionSplitter).forEach(t -> ((OptionSplitter)t).title.setHorizontalAlignment(this.titleHorizontalAlignment == HorizontalAlignment.CENTER ? HorizontalAlignment.CENTER : HorizontalAlignment.LEFT));
    }

    @Override
    public void layout() {
        this.container.setBounds(0, 0, this.width, this.height);
        super.layout();
    }

    public static class OptionContainerVertical
    extends TVerticalScrollContainer {
        @Override
        public void layout() {
            int count = 0;
            int gapBetweenOptions = ((TOptionsPanel)this.getParentLazy()).gapBetweenOptions;
            for (int i = 0; i < this.children.size(); ++i) {
                TWidget tWidget = (TWidget)this.children.get(i);
                if (!tWidget.isVisibleT()) continue;
                if (count == 0) {
                    tWidget.setBounds(gapBetweenOptions, gapBetweenOptions, this.getUsableWidth() - 2 * gapBetweenOptions, tWidget.getPreferredSize().y);
                } else {
                    LayoutHelper.BBottomOfA(tWidget, gapBetweenOptions, Util.findBefore(this.children, i, TWidget::isVisibleT), this.getUsableWidth() - 2 * gapBetweenOptions, tWidget.getPreferredSize().y);
                }
                ++count;
            }
            super.layout();
        }
    }

    public static class HorizontalTitledOption<T extends TWidget>
    extends TPanel {
        protected final TLabel title;
        protected final T controller;

        public HorizontalTitledOption(Component title, T controller) {
            this.title = new TLabel(title);
            this.add(this.title);
            this.controller = controller;
            this.add((TWidget)controller);
            this.title.setHorizontalAlignment(HorizontalAlignment.RIGHT).setAutoScroll(false);
        }

        @Override
        public void layout() {
            int gapBetweenOptions = ((TOptionsPanel)this.getParentLazy().getParentLazy()).gapBetweenOptions;
            this.title.setBounds(0, 0, this.width / 2 - gapBetweenOptions, this.height);
            this.controller.setBounds(this.width / 2 + gapBetweenOptions, 0, this.width / 2 - gapBetweenOptions * 2, this.height);
            super.layout();
        }

        @Override
        public Vector2i getPreferredSize() {
            int actionY = this.controller.getPreferredSize().y;
            return new Vector2i(this.width, Math.max(actionY, 20));
        }

        public TLabel getTitle() {
            return this.title;
        }

        public T getController() {
            return this.controller;
        }
    }

    public static class OptionSplitter
    extends HorizontalTitledOption<TPanel> {
        public OptionSplitter(Component title) {
            super(title, new TPanel());
            this.title.setHorizontalAlignment(HorizontalAlignment.LEFT);
            this.setBackground(0x20FFFFFF);
        }
    }
}

