/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.advanced;

import cn.ussshenzhou.t88.gui.advanced.TCommandConstrainedEditBox;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TSelectList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.neoforge.client.ClientCommandHandler;
import net.neoforged.neoforge.client.ClientCommandSourceStack;

public class TSuggestedEditBox
extends TPanel {
    private final TCommandConstrainedEditBox editBox;
    private final TSelectList<String> suggestionList;

    public TSuggestedEditBox(Consumer<CommandDispatcher<CommandSourceStack>> consumer) {
        this.editBox = new TCommandConstrainedEditBox(consumer){

            @Override
            public void setFocused(boolean pIsFocused) {
                super.setFocused(pIsFocused);
                TSuggestedEditBox.this.suggestionList.setVisibleT(pIsFocused);
            }
        };
        this.editBox.addResponder(s -> this.updateSuggestion((String)s));
        this.suggestionList = new TSelectList<String>(12, 0){

            public boolean isFocused() {
                return super.isFocused() || TSuggestedEditBox.this.editBox.isFocused();
            }
        };
        this.suggestionList.setBackground(-16777216);
        this.suggestionList.setHorizontalAlignment(HorizontalAlignment.LEFT);
        this.suggestionList.setSelectedForeGround(-197632);
        this.add(this.editBox);
        this.add(this.suggestionList);
    }

    public TSuggestedEditBox(CommandDispatcher<CommandSourceStack> dispatcher) {
        this((CommandDispatcher<CommandSourceStack> d) -> {});
        this.editBox.setDispatcher(dispatcher);
    }

    @Override
    public void tickT() {
        super.tickT();
        if (this.isOutOfParentScrollContainerScissor()) {
            this.suggestionList.setVisibleT(false);
        }
    }

    @Override
    public void layout() {
        this.editBox.setBounds(0, 0, this.width, this.height);
        super.layout();
    }

    @Override
    protected void renderChildren(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.editBox.isVisible()) {
            this.editBox.render(guigraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    @Override
    public void renderTop(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.suggestionList.isVisibleT()) {
            this.suggestionList.render(guigraphics, pMouseX, pMouseY, pPartialTick);
        }
        super.renderTop(guigraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void updateSuggestion(String value) {
        ClientCommandSourceStack sourceStack = ClientCommandHandler.getSource();
        ParseResults parseResults = this.editBox.dispatcher.parse(value, (Object)sourceStack);
        try {
            CompletableFuture suggestions = this.editBox.dispatcher.getCompletionSuggestions(parseResults, this.editBox.getCursorPosition());
            suggestions.thenRun(() -> {
                if (suggestions.isDone()) {
                    try {
                        List list = ((Suggestions)suggestions.get()).getList();
                        this.updateSuggestionList(list);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void updateSuggestionList(List<Suggestion> list) {
        this.suggestionList.clearElement();
        if (!list.isEmpty()) {
            Font font = Minecraft.getInstance().font;
            this.suggestionList.setVisibleT(true);
            ArrayList<String> texts = new ArrayList<String>();
            int w = 0;
            for (Suggestion suggestion : list) {
                texts.add(suggestion.getText());
                w = Math.max(w, font.width(suggestion.getText()));
            }
            this.suggestionList.addElement(texts);
            if (Minecraft.getInstance().screen != null) {
                int listY;
                int s = (int)this.getParentScroll().y;
                int h = texts.size() * this.suggestionList.getItemHeight() + 4;
                if (this.y - s <= Minecraft.getInstance().screen.height / 2) {
                    listY = this.y + this.height + 1;
                    h = Math.min(h, Minecraft.getInstance().screen.height - listY + s);
                } else {
                    listY = Math.max(0, this.y - texts.size() * this.suggestionList.getItemHeight() - 4);
                    h = Math.min(h, this.getYT() - s - 1);
                }
                w = w + this.suggestionList.getScrollbarGap() + 6 + 2;
                this.suggestionList.setAbsBounds(this.calculateSuggestionX(w), listY, w, h);
                if (this.suggestionList.getSelected() == null) {
                    this.suggestionList.setSelected(0);
                }
            }
        } else {
            this.suggestionList.setVisibleT(false);
        }
    }

    private int calculateSuggestionX(int l) {
        int w;
        int i = this.editBox.getCurrentWordBeginX() - 1;
        if (i + l > (w = Minecraft.getInstance().screen.width - 5)) {
            return w - l;
        }
        return i;
    }

    public void applySuggestion() {
        TSelectList.Entry e = (TSelectList.Entry)this.suggestionList.getSelected();
        if (e != null) {
            String suggestion = (String)((TSelectList.Entry)this.suggestionList.getSelected()).getContent();
            String s = this.editBox.getValue();
            if ("[".equals(suggestion) || "]".equals(suggestion) || "{".equals(suggestion) || "}".equals(suggestion)) {
                this.editBox.setValue(s.substring(0, this.editBox.getCursorPosition()) + suggestion + s.substring(this.editBox.getCursorPosition()));
                return;
            }
            if (s.isEmpty()) {
                this.editBox.setValue(suggestion);
            } else {
                int a = this.findLastSplitter(s);
                int b = s.indexOf(" ", this.editBox.getCursorPosition());
                if (a == -1) {
                    this.editBox.setValue((String)(b == -1 ? suggestion : suggestion + s.substring(b)));
                } else if (b == -1) {
                    this.editBox.setValue(s.substring(0, a + 1) + suggestion);
                } else {
                    this.editBox.setValue(s.substring(0, a + 1) + suggestion + s.substring(b));
                }
                this.editBox.moveCursorTo(a + 1 + suggestion.length(), true);
            }
        }
    }

    private int findLastSplitter(String s) {
        String[] splitters = new String[]{" ", ",", "[", "{"};
        int i = -1;
        int j = 0;
        while (i == -1) {
            try {
                i = s.lastIndexOf(splitters[j], this.editBox.getCursorPosition());
                ++j;
            }
            catch (IndexOutOfBoundsException ignored) {
                break;
            }
        }
        return i;
    }

    public TCommandConstrainedEditBox getEditBox() {
        return this.editBox;
    }

    public TSelectList<String> getSuggestionList() {
        return this.suggestionList;
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.editBox.isFocused()) {
            if (pKeyCode == 258 || pKeyCode == 257) {
                this.applySuggestion();
                return true;
            }
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        return false;
    }
}

