/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.container;

import cn.ussshenzhou.t88.gui.container.TScrollContainer;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2d;

public class TVerticalScrollContainer
extends TPanel
implements TScrollContainer {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    protected double scrollAmount = 0.0;
    protected double prevScrollAmount = 0.0;
    protected int bottomY = 0;
    protected static int speedFactor = 12;
    protected int scrollbarGap = 0;
    protected int bottomMargin = 5;

    public TVerticalScrollContainer() {
        this.setBackground(Integer.MIN_VALUE);
    }

    @Override
    public void layout() {
        this.initPos();
        super.layout();
    }

    protected void initPos() {
        this.bottomY = 0;
        for (TWidget tWidget : this.children) {
            int y = tWidget.getYT() + tWidget.getSize().y;
            if (this.bottomY >= y) continue;
            this.bottomY = y;
        }
        this.bottomY += this.bottomMargin;
    }

    @Override
    public void tickT() {
        this.prevScrollAmount = this.scrollAmount;
        super.tickT();
    }

    @Override
    public void render(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderScrollBar(guigraphics);
        super.render(guigraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    protected void renderChildren(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Vector2d scroll = this.getParentScroll();
        guigraphics.enableScissor((int)((double)this.x - scroll.x), (int)((double)this.y - scroll.y), (int)((double)(this.x + this.width) - scroll.x), (int)((double)(this.y + this.height) - scroll.y));
        this.prepareTranslate(guigraphics, pPartialTick);
        super.renderChildren(guigraphics, pMouseX, pMouseY, pPartialTick);
        this.endTranslate(guigraphics, pPartialTick);
        guigraphics.disableScissor();
    }

    @Override
    public void renderTop(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.prepareTranslate(guigraphics, pPartialTick);
        super.renderTop(guigraphics, pMouseX, pMouseY, pPartialTick);
        this.endTranslate(guigraphics, pPartialTick);
    }

    protected void prepareTranslate(GuiGraphics guigraphics, float pPartialTick) {
        guigraphics.pose().translate(0.0f, (float)Mth.lerp((double)pPartialTick, (double)(-this.prevScrollAmount), (double)(-this.scrollAmount)));
    }

    protected void endTranslate(GuiGraphics guigraphics, float pPartialTick) {
        guigraphics.pose().translate(0.0f, (float)(-Mth.lerp((double)pPartialTick, (double)(-this.prevScrollAmount), (double)(-this.scrollAmount))));
    }

    @Override
    protected void renderBackground(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.getMaxScroll() > 0) {
            guigraphics.fill(this.x, this.y, this.x + this.width - this.getScrollbarGap() - 6, this.y + this.height, this.background);
        } else {
            guigraphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, this.background);
        }
    }

    protected void renderScrollBar(GuiGraphics guiGraphics) {
        int k1 = this.getMaxScroll();
        if (k1 > 0) {
            int l1 = this.getScrollBarX();
            int k = (int)((float)(this.height * this.height) / (float)this.bottomY);
            k = Mth.clamp((int)k, (int)32, (int)(this.height - 8));
            int l = (int)this.getScrollAmount() * (this.height - k) / k1 + this.getYT();
            if (l < this.getYT()) {
                l = this.getYT();
            }
            guiGraphics.fill(l1, this.getYT(), l1 + 6, this.getYT() + this.height, -16777216);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, l1, l, 6, k);
        }
    }

    protected int getScrollBarX() {
        return this.getXT() + this.width - 6;
    }

    public int getUsableWidth() {
        return this.width - 6 - this.scrollbarGap;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.isInRange(pMouseX, pMouseY, this.scrollbarGap, this.scrollbarGap)) {
            for (TWidget tWidget : TVerticalScrollContainer.reversed(this.children)) {
                if (!tWidget.mouseDragged(pMouseX, pMouseY + this.scrollAmount, pButton, pDragX, pDragY)) continue;
                return true;
            }
            if (pMouseX > (double)(this.getScrollBarX() - this.scrollbarGap - 6)) {
                double d0 = Math.max(1, this.getMaxScroll());
                int j = Mth.clamp((int)((int)((float)(this.height * this.height) / (float)this.bottomY)), (int)32, (int)this.height);
                double d1 = Math.max(1.0, d0 / (double)(this.height - j));
                this.addScrollAmount(-pDragY * d1 / (double)speedFactor);
            } else {
                this.addScrollAmount(pDragY / (double)speedFactor);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        if (this.isInRange(pMouseX, pMouseY) && !super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY)) {
            this.addScrollAmount(deltaY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isInRange(pMouseX, pMouseY)) {
            return super.mouseClicked(pMouseX, pMouseY + this.scrollAmount, pButton);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.isInRange(pMouseX, pMouseY)) {
            return super.mouseReleased(pMouseX, pMouseY + this.scrollAmount, pButton);
        }
        return false;
    }

    public int getMaxScroll() {
        return Math.max(0, this.bottomY - this.getYT() - this.getHeight());
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    @Override
    public Vector2d getScroll() {
        return new Vector2d(0.0, this.scrollAmount);
    }

    public void addScrollAmount(double deltaScroll) {
        double result = Mth.clamp((double)(this.scrollAmount + (deltaScroll = -deltaScroll * (double)speedFactor)), (double)0.0, (double)this.getMaxScroll());
        if (Double.isNaN(result)) {
            return;
        }
        this.scrollAmount = result;
    }

    public int getScrollbarGap() {
        return this.scrollbarGap;
    }

    public void setScrollbarGap(int scrollbarGap) {
        this.scrollbarGap = scrollbarGap;
    }

    public void setScrollAmountDirectly(double scrollAmount) {
        this.prevScrollAmount = this.scrollAmount;
        this.scrollAmount = scrollAmount;
    }
}

