/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.notification;

import cn.ussshenzhou.t88.gui.HudManager;
import cn.ussshenzhou.t88.gui.util.Border;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import net.minecraft.network.chat.Component;
import org.joml.Vector2i;

public class TSimpleNotification
extends TLabel {
    private int life;

    public TSimpleNotification(Component text, int lifeSeconds, Severity severity) {
        super(text);
        this.life = lifeSeconds * 20;
        this.setHorizontalAlignment(HorizontalAlignment.CENTER);
        this.setBackground(severity.background);
        this.setBorder(new Border(severity.foreGround, 1));
    }

    public static TSimpleNotification fire(Component text, int lifeSeconds, Severity severity) {
        TSimpleNotification notify = new TSimpleNotification(text, lifeSeconds, severity);
        HudManager.addOrReplaceIfSameClassExist(notify);
        return notify;
    }

    @Override
    public void resizeAsHud(int screenWidth, int screenHeight) {
        Vector2i size = this.getPreferredSize().add(16, 6);
        this.setAbsBounds((screenWidth - size.x) / 2, (int)((double)screenHeight * 0.62), size);
        super.resizeAsHud(screenWidth, screenHeight);
    }

    @Override
    public void tickT() {
        if (this.life <= 0) {
            HudManager.remove(this);
        }
        --this.life;
        super.tickT();
    }

    public static enum Severity {
        ERROR(-1372144, -2139092727),
        WARN(-1731584, -2139073792),
        TIP(-12391627, -2145091555),
        INFO(-15608341, -2146864000);

        public final int foreGround;
        public final int background;

        private Severity(int foreGround, int background) {
            this.foreGround = foreGround;
            this.background = background;
        }
    }
}

