/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.container.TScrollContainer;
import cn.ussshenzhou.t88.gui.screen.TScreen;
import cn.ussshenzhou.t88.gui.util.Border;
import cn.ussshenzhou.t88.gui.util.ColorManager;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.util.HorizontalColoredRectangleRenderState;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetTooltipHolder;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2d;
import org.joml.Vector2i;

public abstract class TComponent
implements TWidget {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int relativeX;
    protected int relativeY;
    protected boolean visible = true;
    protected int background = 0;
    protected int foreground = ColorManager.get().defaultForeground();
    protected ArrayList<TWidget> children = new ArrayList();
    protected Border border = null;
    TComponent parent = null;
    TScreen parentScreen = null;
    final int id = (int)(Math.random() * 2.147483647E9);
    protected boolean showHudEvenLoggedOut = false;
    @Nullable
    private WidgetTooltipHolder tooltip;
    @Nullable
    private GuiEventListener focusedChild = null;

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.relativeX = x;
        this.relativeY = y;
        if (this.parent != null) {
            this.x = x + this.parent.x;
            this.y = y + this.parent.y;
        } else {
            this.x = x;
            this.y = y;
        }
        this.width = width;
        this.height = height;
    }

    @Override
    public void setAbsBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void layout() {
        for (TWidget widget : this.children) {
            widget.layout();
        }
    }

    public void resizeAsHud(int screenWidth, int screenHeight) {
        this.layout();
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.border != null) {
            this.renderBorder(graphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderChildren(graphics, pMouseX, pMouseY, pPartialTick);
        WidgetTooltipHolder t = this.getTooltip();
        if (t != null) {
            Vector2d scroll = this.getParentScroll();
            boolean inRange = this.getParentInstanceOfOptional(TScrollContainer.class).map(tScrollContainer -> tScrollContainer.isInRange(pMouseX, pMouseY)).orElse(true) != false && this.isInRange((double)pMouseX + scroll.x, (double)pMouseY + scroll.y);
            t.refreshTooltipForNextRenderPass(graphics, pMouseX, pMouseY, inRange, this.isFocused(), this.getRectangle());
        }
    }

    protected void renderBorder(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int thickness = this.border.getThickness();
        int color = this.border.getColor();
        Border.renderBorder(graphics, color, thickness, this.x, this.y, this.width, this.height);
    }

    protected void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, this.background);
    }

    protected void renderChildren(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        for (TWidget tWidget : this.children) {
            if (!tWidget.isVisibleT()) continue;
            tWidget.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    @Override
    public void renderTop(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        for (TWidget w : this.children) {
            if (!w.isVisibleT()) continue;
            w.renderTop(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    public TComponent setTooltip(@Nullable WidgetTooltipHolder tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public TComponent setTooltip(@Nullable Tooltip tooltip) {
        WidgetTooltipHolder widgetTooltipHolder = new WidgetTooltipHolder();
        widgetTooltipHolder.set(tooltip);
        return this.setTooltip(widgetTooltipHolder);
    }

    @Nullable
    public WidgetTooltipHolder getTooltip() {
        return this.tooltip;
    }

    public TComponent setTooltipDelay(int pTooltipMsDelay) {
        if (this.tooltip != null) {
            this.tooltip.setDelay(Duration.ofMillis(pTooltipMsDelay));
        }
        return this;
    }

    @Override
    public void tickT() {
        this.tickChildren();
    }

    public void tickChildren() {
        for (TWidget tWidget : this.children) {
            tWidget.tickT();
        }
    }

    @Override
    public Vector2i getPreferredSize() {
        return new Vector2i(this.width, this.height);
    }

    @Override
    public Vector2i getSize() {
        return new Vector2i(this.width, this.height);
    }

    public TComponent addAll(TWidget ... children) {
        Stream.of(children).forEach(this::add);
        return this;
    }

    public TComponent addAll(Collection<TWidget> children) {
        children.forEach(this::add);
        return this;
    }

    public TComponent add(TWidget child) {
        this.children.add(child);
        child.setParent(this);
        return this;
    }

    public ImmutableList<TWidget> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public static <T> Iterable<T> reversed(final List<T> list) {
        return () -> new Iterator<T>(){
            private final ListIterator<T> iter;
            {
                this.iter = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasPrevious();
            }

            @Override
            public T next() {
                return this.iter.previous();
            }
        };
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseClicked(pMouseX, pMouseY, pButton)) continue;
            this.setFocusedChild(tWidget);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseReleased(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || !tWidget.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.focusedChild != null && this.focusedChild.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || tWidget == this.focusedChild || !tWidget.keyPressed(pKeyCode, pScanCode, pModifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || !tWidget.keyReleased(pKeyCode, pScanCode, pModifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.focusedChild != null && this.focusedChild.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        for (TWidget tWidget : TComponent.reversed(this.children)) {
            if (!tWidget.isVisibleT() || tWidget == this.focusedChild || !tWidget.charTyped(pCodePoint, pModifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onFinalClose() {
        TComponent.reversed(this.children).forEach(TWidget::onFinalClose);
    }

    @Override
    public TComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TComponent parent) {
        this.parent = parent;
    }

    @Override
    public void setParentScreen(@Nullable TScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    @Override
    @Nullable
    public TScreen getParentScreen() {
        return this.parentScreen;
    }

    public void remove(TWidget tWidget) {
        this.children.remove(tWidget);
    }

    public void setBorder(@Nullable Border border) {
        this.border = border;
    }

    @Override
    public boolean isVisibleT() {
        return this.visible;
    }

    @Override
    public void setVisibleT(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getXT() {
        return this.x;
    }

    @Override
    public int getYT() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBackground() {
        return this.background;
    }

    public TComponent setBackground(int background) {
        this.background = background;
        return this;
    }

    public int getForeground() {
        return this.foreground;
    }

    public TComponent setForeground(int foreground) {
        this.foreground = foreground;
        return this;
    }

    public boolean isShowHudEvenLoggedOut() {
        return this.showHudEvenLoggedOut;
    }

    public TComponent setShowHudEvenLoggedOut(boolean showHudEvenLoggedOut) {
        this.showHudEvenLoggedOut = showHudEvenLoggedOut;
        return this;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TComponent) {
            TComponent component = (TComponent)obj;
            return component.id == this.id;
        }
        return false;
    }

    protected void setFocusedChild(@Nullable GuiEventListener child) {
        if (this.focusedChild != null && this.focusedChild != child) {
            this.focusedChild.setFocused(false);
        }
        this.focusedChild = child;
    }

    @Nullable
    protected GuiEventListener getFocusedChild() {
        return this.focusedChild;
    }

    public void setFocused(boolean p_265728_) {
        if (!p_265728_ && this.focusedChild != null) {
            this.focusedChild.setFocused(false);
            this.focusedChild = null;
        }
    }

    public boolean isFocused() {
        return this.focusedChild != null;
    }

    public void drawStringSingleLine(GuiGraphics graphics, Font font, Component text, float fontSize, HorizontalAlignment align, int minX, int maxX, int minY, int maxYOnlyForScissor, int color) {
        TComponent.drawStringSingleLine(this, graphics, font, text, fontSize, align, minX, maxX, minY, maxYOnlyForScissor, color);
    }

    public static void drawStringSingleLine(TWidget thiz, GuiGraphics graphics, Font font, Component text, float fontSize, HorizontalAlignment align, int minX, int maxX, int minY, int maxYOnlyForScissor, int color) {
        graphics.pose().pushMatrix();
        float scaleFactor = fontSize / 7.0f;
        int need = font.width((FormattedText)text);
        int available = maxX - minX;
        int extra = need - available;
        if (extra > 0) {
            Vector2d scroll = thiz.getParentScroll();
            graphics.enableScissor((int)((double)minX - scroll.x), minY, (int)((double)maxX - scroll.x), maxYOnlyForScissor);
            graphics.pose().scale(scaleFactor, scaleFactor);
            minX = (int)((float)minX / scaleFactor);
            maxX = (int)((float)maxX / scaleFactor);
            minY = (int)((float)minY / scaleFactor);
            maxYOnlyForScissor = (int)((float)maxYOnlyForScissor / scaleFactor);
            TComponent.renderScrollingString(extra, graphics, font, text, minX, maxX, minY, maxYOnlyForScissor, color);
            graphics.disableScissor();
        } else {
            graphics.pose().scale(scaleFactor, scaleFactor);
            minX = (int)((float)minX / scaleFactor);
            minY = (int)((float)minY / scaleFactor);
            switch (align) {
                case LEFT: {
                    graphics.drawString(font, text, minX, minY, color);
                    break;
                }
                case CENTER: {
                    graphics.drawString(font, text, minX - extra / 2, minY, color);
                    break;
                }
                case RIGHT: {
                    graphics.drawString(font, text, minX - extra, minY, color);
                }
            }
        }
        graphics.pose().popMatrix();
    }

    public static void drawStringSingleLine(TWidget thiz, GuiGraphics graphics, Font font, Component text, HorizontalAlignment align, int minX, int maxX, int minY, int color) {
        TComponent.drawStringSingleLine(thiz, graphics, font, text, 7.0f, align, minX, maxX, minY, minY + 9, color);
    }

    public static void drawStringSingleLine(TWidget thiz, GuiGraphics graphics, Font font, Component text, int minX, int maxX, int minY, int maxYOnlyForScissor, int color) {
        TComponent.drawStringSingleLine(thiz, graphics, font, text, 7.0f, HorizontalAlignment.LEFT, minX, maxX, minY, maxYOnlyForScissor, color);
    }

    public static void drawStringSingleLine(TWidget thiz, GuiGraphics graphics, Font font, Component text, int minX, int maxX, int minY, int color) {
        TComponent.drawStringSingleLine(thiz, graphics, font, text, 7.0f, HorizontalAlignment.LEFT, minX, maxX, minY, minY + 9, color);
    }

    public void drawStringSingleLine(GuiGraphics graphics, Font font, Component text, HorizontalAlignment align, int minX, int maxX, int minY, int color) {
        TComponent.drawStringSingleLine(this, graphics, font, text, 7.0f, align, minX, maxX, minY, minY + 9, color);
    }

    public void drawStringSingleLine(GuiGraphics graphics, Font font, Component text, int minX, int maxX, int minY, int maxYOnlyForScissor, int color) {
        TComponent.drawStringSingleLine(this, graphics, font, text, 7.0f, HorizontalAlignment.LEFT, minX, maxX, minY, maxYOnlyForScissor, color);
    }

    public void drawStringSingleLine(GuiGraphics graphics, Font font, Component text, int minX, int maxX, int minY, int color) {
        TComponent.drawStringSingleLine(this, graphics, font, text, 7.0f, HorizontalAlignment.LEFT, minX, maxX, minY, minY + 9, color);
    }

    public static void renderScrollingString(int extra, GuiGraphics graphics, Font font, Component text, int minX, int maxX, int minY, int maxY, int color) {
        double d0 = (double)Util.getMillis() / 1000.0;
        double d1 = Math.max((double)extra * 0.5, 3.0);
        double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
        double d3 = Mth.lerp((double)d2, (double)0.0, (double)extra);
        graphics.drawString(font, text, minX - (int)d3, minY, color);
    }

    public void fillGradientHorizontal(GuiGraphics graphics, int minX, int minY, int maxX, int maxY, int colorFrom, int colorTo) {
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new HorizontalColoredRectangleRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)graphics.pose()), minX, minY, maxX, maxY, colorFrom, colorTo, graphics.scissorStack.peek()));
    }
}

