/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.event.TWidgetContentUpdatedEvent;
import cn.ussshenzhou.t88.gui.util.ITranslatable;
import cn.ussshenzhou.t88.gui.widegt.TButton;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TCycleButton<E>
extends TButton {
    LinkedList<Entry> values = new LinkedList();
    int cycleIndex = 0;

    public TCycleButton() {
        super((Component)Component.empty());
        this.setOnPress(pButton -> this.cycleOnce(1));
    }

    public TCycleButton(Collection<Entry> entries) {
        this();
        entries.forEach(this::addElement);
    }

    public void addElement(E e) {
        this.addElement(new Entry(this, e));
    }

    public void addElement(E e, Consumer<TCycleButton<E>> consumer) {
        this.addElement(new Entry(this, e, consumer));
    }

    public void addElement(Entry e) {
        int index = this.values.indexOf(e);
        if (index >= 0) {
            this.values.remove(index);
        }
        this.values.add(e);
        if ("".equals(this.getMessage().getString())) {
            this.setMessage(e.getNarration());
        }
    }

    public void removeElement(Entry e) {
        this.values.remove(e);
    }

    public void removeElement(E e) {
        this.removeElement(new Entry(this, e));
    }

    public void removeElement(Predicate<Entry> predicate) {
        this.values.stream().filter(predicate).findFirst().ifPresent(this::removeElement);
    }

    public int getSelectedIndex() {
        return this.cycleIndex;
    }

    public LinkedList<Entry> getValues() {
        return this.values;
    }

    @Nullable
    public Entry getSelected() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(this.cycleIndex);
    }

    public Optional<Entry> getSelectedOptional() {
        if (this.values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.values.get(this.cycleIndex));
    }

    public void select(int index) throws IndexOutOfBoundsException {
        this.cycleIndex = index = Mth.clamp((int)index, (int)0, (int)(this.values.size() - 1));
        this.setMessage(this.values.get(this.cycleIndex).getNarration());
        Consumer c = this.values.get((int)this.cycleIndex).onSwitched;
        if (c != null) {
            c.accept(this);
        }
        NeoForge.EVENT_BUS.post((Event)new TWidgetContentUpdatedEvent(this));
    }

    public void selectWithoutRespond(int index) throws IndexOutOfBoundsException {
        this.cycleIndex = index = Mth.clamp((int)index, (int)0, (int)(this.values.size() - 1));
        this.setMessage(this.values.get(this.cycleIndex).getNarration());
        NeoForge.EVENT_BUS.post((Event)new TWidgetContentUpdatedEvent(this));
    }

    public void select(Entry entry) {
        this.select(this.values.indexOf(entry));
    }

    public void select(E content) {
        this.select(this.values.indexOf(new Entry(this, content)));
    }

    public void select(Predicate<Entry> predicate) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            this.select(i);
            return;
        }
    }

    public void selectWithoutRespond(Entry entry) {
        this.selectWithoutRespond(this.values.indexOf(entry));
    }

    public void selectWithoutRespond(E content) {
        this.selectWithoutRespond(this.values.indexOf(new Entry(this, content)));
    }

    public void selectWithoutRespond(Predicate<Entry> predicate) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            this.selectWithoutRespond(i);
            return;
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isInRange(pMouseX, pMouseY) && pButton == 1) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.cycleOnce(-1);
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    protected void cycleOnce(int i) {
        if (!this.values.isEmpty()) {
            this.cycleIndex += i;
            if (this.cycleIndex < 0) {
                this.cycleIndex = this.values.size() - 1;
            } else if (this.cycleIndex > this.values.size() - 1) {
                this.cycleIndex = 0;
            }
            this.select(this.cycleIndex);
        } else {
            this.cycleIndex = 0;
            this.setMessage((Component)Component.empty());
            NeoForge.EVENT_BUS.post((Event)new TWidgetContentUpdatedEvent(this));
        }
    }

    public class Entry {
        E content;
        Consumer<TCycleButton<E>> onSwitched;

        public Entry(TCycleButton this$0, E content) {
            this.content = content;
            this.onSwitched = null;
        }

        public Entry(TCycleButton this$0, E content, Consumer<TCycleButton<E>> onSwitched) {
            this.content = content;
            this.onSwitched = onSwitched;
        }

        public Component getNarration() {
            String s;
            Language language = Language.getInstance();
            Object e = this.content;
            if (e instanceof ITranslatable) {
                ITranslatable translatable = (ITranslatable)e;
                s = translatable.translateKey();
            } else {
                s = this.content.toString();
            }
            if (language.has(s)) {
                return Component.translatable((String)s);
            }
            return Component.literal((String)s);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry entry = (Entry)obj;
                return entry.content.toString().equals(this.content.toString());
            }
            return false;
        }

        public E getContent() {
            return this.content;
        }

        public void setContent(E content) {
            this.content = content;
        }

        public Consumer<TCycleButton<E>> getOnSwitched() {
            return this.onSwitched;
        }

        public void setOnSwitched(Consumer<TCycleButton<E>> onSwitched) {
            this.onSwitched = onSwitched;
        }
    }
}

