/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.util.ColorManager;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TDotChart<T extends Number>
extends TPanel {
    protected T[] numbers;
    double yMin;
    double yMax;
    double yUpper;
    double yLower;
    int xMax;
    int minX;
    int minY;
    int maxX;
    int maxY;
    int c0 = ColorManager.get().defaultForeground();
    Font font;
    int labelGap;
    int spikeHeight;
    protected TLabel xAxisLabel;
    protected TLabel yAxisLabel;

    public TDotChart(T[] numbers, Component xAxisLabel, Component yAxisLabel) {
        this.font = Minecraft.getInstance().font;
        this.labelGap = 1;
        this.spikeHeight = 2;
        this.numbers = numbers;
        this.xAxisLabel = new TLabel(xAxisLabel);
        this.add(this.xAxisLabel);
        this.yAxisLabel = new TLabel(yAxisLabel);
        this.yAxisLabel.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        this.add(this.yAxisLabel);
        this.initChart();
    }

    private void initChart() {
        Arrays.stream(this.numbers).min((rec$, x$0) -> ((Comparable)rec$).compareTo(x$0)).ifPresent(t -> {
            this.yMin = t.doubleValue();
        });
        Arrays.stream(this.numbers).max((rec$, x$0) -> ((Comparable)rec$).compareTo(x$0)).ifPresent(t -> {
            this.yMax = t.doubleValue();
        });
        this.yUpper = this.yMax + (this.yMax - this.yMin) * 0.1;
        this.yLower = this.yMin - (this.yMax - this.yMin) * 0.1;
        this.xMax = (int)((double)this.numbers.length * 1.1);
    }

    @Override
    public void layout() {
        this.minX = (int)((double)this.getXT() + (double)this.width * 0.1);
        this.minY = (int)((double)this.getYT() + (double)this.height * 0.1);
        this.maxX = (int)((double)this.minX + (double)this.width * 0.8);
        this.maxY = (int)((double)this.minY + (double)this.height * 0.8);
        int y0 = this.yAxisLabel.getPreferredSize().y;
        this.yAxisLabel.setAbsBounds(0, this.minY - y0, this.minX - 1 - this.labelGap, y0);
        this.xAxisLabel.setAbsBounds(this.maxX, this.maxY + 1 + this.labelGap, (int)((double)this.width * 0.1), this.xAxisLabel.getPreferredSize().y);
        super.layout();
    }

    @Override
    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderAxis(graphics);
        this.renderDots(graphics);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderAxis(GuiGraphics graphics) {
        graphics.fill(this.minX - 1, this.minY, this.minX, this.maxY + 1, this.c0);
        graphics.fill(this.minX, this.maxY, this.maxX, this.maxY + 1, this.c0);
        graphics.drawString(this.font, (Component)Component.literal((String)String.valueOf(0)), this.minX - 1, this.maxY + 1 + this.labelGap, this.c0);
        MutableComponent text = Component.literal((String)String.valueOf(this.xMax));
        int x0 = (int)((double)this.minX + (double)(this.maxX - this.minX) * 0.9);
        graphics.fill(x0, this.maxY - this.spikeHeight, x0 + 1, this.maxY, this.c0);
        graphics.drawString(this.font, (Component)text, x0 - this.font.width((FormattedText)text) / 2, this.xAxisLabel.getYT(), this.c0);
        int fontSizeOffsetY = 4;
        int x1 = this.minX - 1 - this.labelGap;
        this.drawStringSingleLine(graphics, this.font, (Component)Component.literal((String)String.format("%.2f", this.yLower)), HorizontalAlignment.RIGHT, 0, x1, this.maxY - fontSizeOffsetY, this.c0);
        int y0 = (int)((double)this.minY + (double)(this.maxY - this.minY) * 0.9);
        graphics.fill(this.minX, y0, this.minX + this.spikeHeight, y0 + 1, this.c0);
        this.drawStringSingleLine(graphics, this.font, (Component)Component.literal((String)String.valueOf(this.yMin)), HorizontalAlignment.RIGHT, 0, x1, y0 - fontSizeOffsetY, this.c0);
        int y1 = (int)((double)this.minY + (double)(this.maxY - this.minY) * 0.1);
        graphics.fill(this.minX, y1, this.minX + this.spikeHeight, y1 + 1, this.c0);
        this.drawStringSingleLine(graphics, this.font, (Component)Component.literal((String)String.valueOf(this.yMax)), HorizontalAlignment.RIGHT, 0, x1, y1 - fontSizeOffsetY, this.c0);
    }

    protected void renderDots(GuiGraphics graphics) {
        int i = 0;
        float stepX = (float)(this.maxX - this.minX) * 0.9f / (float)this.numbers.length;
        float bottomY = (float)(this.maxY - this.minY) * 0.1f;
        float spaceY = (float)(this.maxY - this.minY) * 0.8f;
        double rangeY = this.yMax - this.yMin;
        int c1 = ColorManager.get().themeColor();
        for (T dot : this.numbers) {
            double v = ((Number)dot).doubleValue();
            int x0 = (int)((float)this.minX + stepX * (float)i);
            int y0 = (int)((double)((float)this.maxY - bottomY) - (v - this.yMin) / rangeY * (double)spaceY);
            graphics.fill(x0, y0, x0 + 1, y0 + 1, c1);
            ++i;
        }
    }
}

