/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.event.ClearEditBoxFocusEvent;
import cn.ussshenzhou.t88.gui.event.TWidgetContentUpdatedEvent;
import cn.ussshenzhou.t88.gui.screen.TScreen;
import cn.ussshenzhou.t88.gui.util.AccessorProxy;
import cn.ussshenzhou.t88.gui.util.VanillaWidget2TComponentHelper;
import cn.ussshenzhou.t88.gui.widegt.TComponent;
import cn.ussshenzhou.t88.gui.widegt.TResponder;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class TEditBox
extends EditBox
implements TWidget,
TResponder<String> {
    TComponent parent = null;
    TScreen parentScreen = null;
    protected final LinkedList<Consumer<String>> responders = new LinkedList();
    protected boolean checkInput = false;

    protected void onClearEditBoxFocusEvent(ClearEditBoxFocusEvent event) {
        this.setFocused(false);
    }

    public TEditBox(Component tipText) {
        super(Minecraft.getInstance().font, 0, 0, 0, 0, tipText);
        this.setMaxLength(32500);
        NeoForge.EVENT_BUS.addListener(this::onClearEditBoxFocusEvent);
        this.setResponder(this::respond);
        this.addResponder((String s) -> NeoForge.EVENT_BUS.post((Event)new TWidgetContentUpdatedEvent(this)));
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (this.isEditable()) {
            boolean canInsert;
            boolean bl = canInsert = !this.checkInput || StringUtil.isAllowedChatCharacter((char)pCodePoint);
            if (canInsert) {
                this.insertText(Character.toString(pCodePoint));
                return true;
            }
        }
        return false;
    }

    public void insertText(String pTextToWrite) {
        String s1;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        String s = pTextToWrite;
        if (this.checkInput) {
            s = StringUtil.filterText((String)pTextToWrite);
        }
        if (k < (l = s.length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
            this.value = s1;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    public boolean isCheckInput() {
        return this.checkInput;
    }

    public void setCheckInput(boolean checkInput) {
        this.checkInput = checkInput;
    }

    @Override
    public void onFinalClose() {
        NeoForge.EVENT_BUS.unregister((Object)this);
        TWidget.super.onFinalClose();
    }

    public TEditBox() {
        this((Component)Component.empty());
    }

    public int getCursorX() {
        return this.getXT() + Minecraft.getInstance().font.width(this.getValue().substring(AccessorProxy.EditBoxProxy.getDisplayPos(this), this.getCursorPosition()));
    }

    public int getCurrentWordBeginX() {
        String s = this.getValue();
        int b = s.lastIndexOf(" ", this.getCursorPosition());
        if (b == this.getCursorPosition()) {
            b = s.lastIndexOf(" ", Mth.clamp((int)(this.getCursorPosition() - 1), (int)0, (int)Integer.MAX_VALUE));
        }
        Font font = Minecraft.getInstance().font;
        return this.getXT() + font.width(s.substring(AccessorProxy.EditBoxProxy.getDisplayPos(this), ++b)) + font.width(" ");
    }

    @Deprecated
    public void setResponder(Consumer<String> pResponder) {
        super.setResponder(pResponder);
    }

    @Override
    public void respond(String value) {
        this.responders.forEach(stringConsumer -> stringConsumer.accept(value));
    }

    @Override
    public void addResponder(Consumer<String> responder) {
        this.responders.add(responder);
    }

    @Override
    public void clearResponders() {
        this.responders.clear();
    }

    @Override
    public boolean isVisibleT() {
        return this.isVisible();
    }

    @Override
    public void setVisibleT(boolean visible) {
        this.setVisible(visible);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        VanillaWidget2TComponentHelper.setBounds(x, y, width, height, this);
    }

    @Override
    public void setAbsBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setFocused(boolean pIsFocused) {
        super.setFocused(pIsFocused);
    }

    @Override
    public void setParent(TComponent parent) {
        this.parent = parent;
    }

    @Override
    public TComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParentScreen(@Nullable TScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    @Override
    @Nullable
    public TScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public int getXT() {
        return this.x;
    }

    @Override
    public int getYT() {
        return this.y;
    }

    @Override
    public Vector2i getPreferredSize() {
        return new Vector2i(this.width, 20);
    }

    @Override
    public Vector2i getSize() {
        return new Vector2i(this.width, this.height);
    }

    @Override
    public void tickT() {
    }

    @Override
    public void layout() {
        this.updateTextPosition();
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.isInRange(pMouseX, pMouseY)) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return false;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (AccessorProxy.EditBoxProxy.isEditBoxEdible(this) && this.isInRange(pMouseX, pMouseY)) {
            this.setFocused(true);
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        return false;
    }

    public void setEditable(boolean pEnabled) {
        String s = Language.getInstance().getOrDefault("gui.t88.invalid");
        if (!pEnabled && "".equals(this.getValue())) {
            this.setValue(s);
            AccessorProxy.EditBoxProxy.setDisplayPos(this, 0);
        } else if (pEnabled && s.equals(this.getValue())) {
            this.setValue("");
        }
        super.setEditable(pEnabled);
    }

    public boolean isEditable() {
        return AccessorProxy.EditBoxProxy.isEditBoxEdible(this);
    }
}

