/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.joml.Vector2i;

public class TLabel
extends TPanel {
    protected Component text;
    protected float fontSize = 7.0f;
    public static final int STD_FONT_SIZE = 7;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected ArrayList<Component> textLines = new ArrayList();
    protected int lineSpacing = 2;
    protected boolean autoScroll = true;
    Font font;

    public TLabel() {
        this.font = Minecraft.getInstance().font;
        this.text = Component.empty();
        this.parseTextLines();
    }

    public TLabel(Component s) {
        this.font = Minecraft.getInstance().font;
        this.text = s;
        this.parseTextLines();
    }

    public TLabel(Component s, int foreground) {
        this(s);
        this.setForeground(foreground);
    }

    protected void parseTextLines() {
        String[] lines = this.text.getString().split("\n");
        this.textLines.clear();
        Stream.of(lines).forEach(line -> this.textLines.add((Component)Component.literal((String)line)));
    }

    public Component getText() {
        return this.text;
    }

    public TLabel setText(Component text) {
        this.text = text;
        this.parseTextLines();
        return this;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public TLabel setFontSize(float size) {
        this.fontSize = size;
        return this;
    }

    public TLabel setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public TLabel setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public TLabel setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
        return this;
    }

    @Override
    public void render(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guigraphics, pMouseX, pMouseY, pPartialTick);
        this.renderText(guigraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderText(GuiGraphics guigraphics, int pMouseX, int pMouseY, float pPartialTick) {
        guigraphics.pose().pushMatrix();
        float y0 = Mth.ceil((float)((float)this.y + ((float)this.height - (this.fontSize + (float)this.lineSpacing) * (float)this.textLines.size()) / 2.0f));
        for (Component line : this.textLines) {
            if (this.autoScroll) {
                this.drawStringSingleLine(guigraphics, this.font, line, this.fontSize, this.horizontalAlignment, this.x, this.x + this.width, (int)y0, (int)(y0 + this.fontSize + (float)this.lineSpacing), this.foreground);
            } else {
                guigraphics.pose().pushMatrix();
                int x0 = this.getAlignedX(line);
                float scaleFactor = this.fontSize / 7.0f;
                guigraphics.pose().scale(scaleFactor, scaleFactor);
                guigraphics.drawString(this.font, line, (int)((float)x0 / scaleFactor), (int)(y0 / scaleFactor), this.foreground);
                guigraphics.pose().popMatrix();
            }
            y0 += this.fontSize + (float)this.lineSpacing;
        }
        guigraphics.pose().popMatrix();
    }

    protected int getAlignedX(Component line) {
        int textWidth = Mth.ceil((float)((float)this.font.width((FormattedText)line) * this.fontSize / 7.0f));
        return switch (this.horizontalAlignment) {
            case HorizontalAlignment.CENTER -> this.x + (this.width - textWidth) / 2;
            case HorizontalAlignment.RIGHT -> this.x + this.width - textWidth;
            default -> this.x;
        };
    }

    @Override
    public Vector2i getPreferredSize() {
        int maxLineWidth = 0;
        for (Component line : this.textLines) {
            maxLineWidth = Mth.ceil((float)Math.max((float)this.font.width((FormattedText)line) * this.fontSize / 7.0f, (float)maxLineWidth));
        }
        return new Vector2i(maxLineWidth, (int)((this.fontSize + (float)this.lineSpacing) * (float)this.textLines.size()) + 1);
    }
}

