/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.gui.widegt;

import cn.ussshenzhou.t88.gui.screen.TScreen;
import cn.ussshenzhou.t88.gui.util.AccessorProxy;
import cn.ussshenzhou.t88.gui.util.HorizontalAlignment;
import cn.ussshenzhou.t88.gui.widegt.TComponent;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class TSelectList<E>
extends ObjectSelectionList<Entry>
implements TWidget {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    public static final int SCROLLBAR_WIDTH = 6;
    TComponent parent = null;
    TScreen parentScreen = null;
    int foreground = -1;
    int background = Integer.MIN_VALUE;
    int selectedForeGround = this.foreground;
    boolean visible = true;
    int scrollbarGap = 0;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    int x1;
    int y1;

    public TSelectList(int pItemHeight, int scrollbarGap) {
        super(Minecraft.getInstance(), 0, 0, 0, pItemHeight);
        this.renderHeader = false;
        this.scrollbarGap = scrollbarGap;
    }

    public TSelectList() {
        this(20, 0);
    }

    public void addElement(E element) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(element));
    }

    public void addElement(E element, Consumer<TSelectList<E>> onSelected) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(element, onSelected));
    }

    public void addElement(Collection<E> elements) {
        for (E e : elements) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(e));
        }
    }

    public ImmutableList<Entry> getElements() {
        return ImmutableList.copyOf((Collection)this.children());
    }

    public void removeElement(Entry entry) {
        this.removeEntry((AbstractSelectionList.Entry)entry);
    }

    public void clearElement() {
        this.setSelected((Entry)null);
        super.children().clear();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        boolean acceptableKey;
        boolean bl = acceptableKey = pKeyCode == 264 || pKeyCode == 265;
        if (this.isFocused() && acceptableKey) {
            Entry selected = (Entry)this.getSelected();
            if (selected == null) {
                this.setSelected(0);
            } else {
                int i = this.children().indexOf((Object)selected);
                if (pKeyCode == 264) {
                    if (i >= this.children().size() - 1) {
                        this.setSelected(0);
                    } else {
                        this.setSelected(i + 1);
                    }
                } else if (i <= 0) {
                    this.setSelected(this.children().size() - 1);
                } else {
                    this.setSelected(i - 1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void tickT() {
    }

    @Override
    public void layout() {
        for (Entry entry : this.children) {
            if (!(entry instanceof TWidget)) continue;
            TWidget widget = (TWidget)((Object)entry);
            widget.layout();
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.updateScrolling(pMouseX, pMouseY, pButton);
        if (!this.isMouseOver(pMouseX, pMouseY)) {
            this.setFocused(false);
        } else {
            Entry e = (Entry)this.getEntryAtPosition(pMouseX, pMouseY);
            if (e != null && e.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.setFocused((GuiEventListener)e);
                this.setDragging(true);
                this.setSelected(e);
                return true;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        if (this.isInRange(pMouseX, pMouseY)) {
            return super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
        }
        return false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.isInRange(pMouseX, pMouseY, 8.0, 8.0)) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return false;
    }

    public void setSelected(@Nullable Entry pSelected) {
        super.setSelected((AbstractSelectionList.Entry)pSelected);
        if (pSelected != null) {
            this.ensureVisible((AbstractSelectionList.Entry)pSelected);
            pSelected.onSelected();
        }
    }

    public void setSelected(int index) {
        int i = Mth.clamp((int)index, (int)0, (int)(this.children().size() - 1));
        this.setSelected((Entry)this.getEntry(i));
    }

    protected int getScrollbarPosition() {
        return this.width + this.x - 6;
    }

    public int getRowLeft() {
        return this.x;
    }

    public int getRowWidth() {
        return this.width - this.scrollbarGap - 6;
    }

    protected void renderBackground(GuiGraphics guigraphics) {
        guigraphics.fill(this.x, this.y, this.x + this.width - this.scrollbarGap - 6, this.y + this.height, this.background);
    }

    @Override
    public boolean isVisibleT() {
        return this.visible;
    }

    @Override
    public void setVisibleT(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.parent != null) {
            this.x = x + this.parent.x;
            this.y = y + this.parent.y;
        } else {
            this.x = x;
            this.y = y;
        }
        this.x1 = this.x + width - this.scrollbarGap - 6;
        this.y1 = this.y + height;
        this.width = width;
        this.height = height;
    }

    @Override
    public void setAbsBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.x1 = this.x + width - this.scrollbarGap - 6;
        this.y1 = this.y + height;
        this.width = width;
        this.height = height;
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
        ResourceLocation resourcelocation = this.minecraft.level == null ? MENU_LIST_BACKGROUND : INWORLD_MENU_LIST_BACKGROUND;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourcelocation, this.getX(), this.getY(), (float)this.getRight(), (float)(this.getBottom() + (int)this.scrollAmount()), this.scrollbarVisible() ? this.getWidth() : this.getRowWidth(), this.getHeight(), 32, 32);
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
        ResourceLocation resourcelocation = this.minecraft.level == null ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
        ResourceLocation resourcelocation1 = this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourcelocation, this.getX(), this.getY() - 2, 0.0f, 0.0f, this.scrollbarVisible() ? this.getWidth() : this.getRowWidth(), 2, 32, 2);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourcelocation1, this.getX(), this.getBottom(), 0.0f, 0.0f, this.scrollbarVisible() ? this.getWidth() : this.getRowWidth(), 2, 32, 2);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int j;
        int i;
        AccessorProxy.AbstractSelectionListProxy.setHovered(this, this.isMouseOver(mouseX, mouseY) ? (Entry)this.getEntryAtPosition(mouseX, mouseY) : null);
        this.renderListBackground(guiGraphics);
        this.enableScissor(guiGraphics);
        if (AccessorProxy.AbstractSelectionListProxy.isRenderHeader(this)) {
            i = this.getRowLeft();
            j = this.getY() + 4 - (int)this.scrollAmount();
            this.renderHeader(guiGraphics, i, j);
        }
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.disableScissor();
        this.renderListSeparators(guiGraphics);
        if (this.scrollbarVisible()) {
            i = this.scrollBarX();
            j = this.scrollerHeight();
            int k = this.scrollBarY();
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_BACKGROUND_SPRITE, i, this.getY(), 6, this.getHeight());
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, i, k, 6, j);
        }
        this.renderDecorations(guiGraphics, mouseX, mouseY);
    }

    protected void enableScissor(GuiGraphics guigraphics) {
        Vector2d scroll = this.getParentScroll();
        guigraphics.enableScissor(this.x, this.y, this.x1, this.y1);
    }

    protected void renderSelection(GuiGraphics guigraphics, int pTop, int pWidth, int pHeight, int pOuterColor, int pInnerColor) {
        int i = this.x + (this.width - pWidth - 6 - this.scrollbarGap) / 2;
        int j = this.x + (this.width + pWidth - 6 - this.scrollbarGap) / 2;
        guigraphics.fill(i, pTop - 2, j, pTop + pHeight + 2, pOuterColor);
        guigraphics.fill(i + 1, pTop - 1, j - 1, pTop + pHeight + 1, pInnerColor);
    }

    @Override
    public int getXT() {
        return this.x;
    }

    @Override
    public int getYT() {
        return this.y;
    }

    public void setScrollbarGap(int scrollbarGap) {
        this.scrollbarGap = scrollbarGap;
    }

    public int getScrollbarGap() {
        return this.scrollbarGap;
    }

    @Override
    public void setParent(TComponent parent) {
        this.parent = parent;
    }

    @Override
    public TComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParentScreen(@Nullable TScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    @Override
    @Nullable
    public TScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public Vector2i getPreferredSize() {
        return null;
    }

    @Override
    public Vector2i getSize() {
        return new Vector2i(this.width, this.height);
    }

    public int getForeground() {
        return this.foreground;
    }

    public void setForeground(int foreground) {
        this.foreground = foreground;
    }

    public int getBackground() {
        return this.background;
    }

    public TSelectList<E> setBackground(int background) {
        this.background = background;
        return this;
    }

    public int getSelectedForeGround() {
        return this.selectedForeGround;
    }

    public void setSelectedForeGround(int selectedForeGround) {
        this.selectedForeGround = selectedForeGround;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry> {
        E content;
        Consumer<TSelectList<E>> consumer;
        protected Integer specialForeground = null;

        public Entry(E content, Consumer<TSelectList<E>> consumer) {
            this.content = content;
            this.consumer = consumer;
        }

        public Entry(E content) {
            this.content = content;
            this.consumer = list -> {};
        }

        public Component getNarration() {
            String s;
            Object e = this.content;
            if (e instanceof Component) {
                Component c = (Component)e;
                return c;
            }
            Language language = Language.getInstance();
            if (language.has(s = this.content.toString())) {
                return Component.translatable((String)s);
            }
            return Component.literal((String)s);
        }

        public void render(GuiGraphics guigraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            Font font = Minecraft.getInstance().font;
            int color = this.specialForeground == null ? (TSelectList.this.getSelected() == this ? TSelectList.this.selectedForeGround : TSelectList.this.foreground) : this.specialForeground;
            Component component = this.getNarration();
            HorizontalAlignment horizontalAlignment = TSelectList.this.horizontalAlignment;
            Objects.requireNonNull(font);
            TComponent.drawStringSingleLine((TWidget)TSelectList.this, guigraphics, font, component, horizontalAlignment, pLeft + 1, pLeft + pWidth - 1, pTop + (pHeight - 9) / 2, color);
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            return true;
        }

        public void onSelected() {
            this.consumer.accept(TSelectList.this);
        }

        public void setConsumer(Consumer<TSelectList<E>> consumer) {
            this.consumer = consumer;
        }

        public E getContent() {
            return this.content;
        }

        public int getSpecialForeground() {
            return this.specialForeground;
        }

        public void setSpecialForeground(int specialForeground) {
            this.specialForeground = specialForeground;
        }

        public void clearSpecialForeground() {
            this.specialForeground = null;
        }
    }
}

