/*
 * Decompiled with CFR 0.152.
 */
package cn.ussshenzhou.t88.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventoryHelper {
    public static List<ItemStack> getAllAsList(Inventory inventory) {
        return InventoryHelper.getAllAsStream(inventory).toList();
    }

    public static Stream<ItemStack> getAllAsStream(Inventory inventory) {
        return StreamSupport.stream(inventory.spliterator(), false).filter(itemStack -> !itemStack.isEmpty());
    }

    public static boolean consume(Inventory inventory, ItemStack need) {
        if (inventory.countItem(need.getItem()) >= need.getCount()) {
            int n = need.getCount();
            List<ItemStack> list = InventoryHelper.getAllAsList(inventory);
            for (ItemStack item : list) {
                if (item.getItem() != need.getItem()) continue;
                if (item.getCount() >= n) {
                    item.shrink(n);
                    break;
                }
                n -= item.getCount();
                item.setCount(0);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeExact(Inventory inventory, ItemStack need) {
        Optional<ItemStack> o = InventoryHelper.getAllAsStream(inventory).filter(itemStack -> ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)need)).findFirst();
        if (o.isPresent()) {
            o.get().setCount(0);
            return true;
        }
        return false;
    }
}

