/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block;

import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import com.mafuyu33.mafishcrossbow.block.entity.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrossbowTurretBlock
extends BaseEntityBlock {
    public static final MapCodec<CrossbowTurretBlock> CODEC = CrossbowTurretBlock.simpleCodec(CrossbowTurretBlock::new);
    public static final Property<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public MapCodec<CrossbowTurretBlock> codec() {
        return CODEC;
    }

    public CrossbowTurretBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            direction = direction.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrossbowTurretBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : CrossbowTurretBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CROSSBOW_TURRET.get()), CrossbowTurretBlockEntity::serverTick);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemEnchantments bookEnchantments;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrossbowTurretBlockEntity)) {
            return InteractionResult.PASS;
        }
        CrossbowTurretBlockEntity turretEntity = (CrossbowTurretBlockEntity)blockEntity;
        ItemStack mainHandStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (mainHandStack.isEmpty()) {
            player.openMenu((MenuProvider)turretEntity);
            return InteractionResult.CONSUME;
        }
        ItemStack stack = mainHandStack;
        if (stack.getItem() == Items.ENCHANTED_BOOK && (bookEnchantments = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)) != null && !bookEnchantments.isEmpty()) {
            ItemEnchantments currentEnchantments = turretEntity.getEnchantments();
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(currentEnchantments);
            bookEnchantments.entrySet().forEach(entry -> {
                int currentLevel = mutable.getLevel((Holder)entry.getKey());
                int newLevel = entry.getIntValue();
                mutable.set((Holder)entry.getKey(), Math.max(currentLevel, newLevel));
            });
            turretEntity.setEnchantments(mutable.toImmutable());
            level.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.isEmpty()) {
            ItemStack slotStack;
            int i;
            ItemStack remaining = player.isCreative() ? stack.copy() : stack;
            int originalCount = remaining.getCount();
            boolean modified = false;
            for (i = 0; i < turretEntity.getContainerSize() && !remaining.isEmpty(); ++i) {
                int currentCount;
                int maxStackSize;
                int spaceLeft;
                slotStack = turretEntity.getItem(i);
                if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remaining) || (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - (currentCount = slotStack.getCount())) <= 0) continue;
                int toAdd = Math.min(spaceLeft, remaining.getCount());
                slotStack.grow(toAdd);
                remaining.shrink(toAdd);
                turretEntity.setChanged();
                modified = true;
            }
            if (!remaining.isEmpty()) {
                for (i = 0; i < turretEntity.getContainerSize() && !remaining.isEmpty(); ++i) {
                    slotStack = turretEntity.getItem(i);
                    if (!slotStack.isEmpty()) continue;
                    ItemStack toInsert = remaining.copy();
                    turretEntity.setItem(i, toInsert);
                    remaining.setCount(0);
                    turretEntity.setChanged();
                    modified = true;
                    break;
                }
            }
            if (modified) {
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 0.8f + level.random.nextFloat() * 0.4f);
                if (!player.isCreative()) {
                    if (remaining.isEmpty()) {
                        stack.setCount(0);
                    } else {
                        stack.setCount(remaining.getCount());
                    }
                }
                return InteractionResult.SUCCESS;
            }
            player.openMenu((MenuProvider)turretEntity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CrossbowTurretBlockEntity) {
            ItemContainerContents container;
            CrossbowTurretBlockEntity blockEntity2 = (CrossbowTurretBlockEntity)blockEntity;
            ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (enchantments != null && !enchantments.isEmpty()) {
                blockEntity2.setEnchantments(enchantments);
            }
            if (stack.has(DataComponents.CONTAINER) && (container = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) != null) {
                NonNullList tempList = NonNullList.withSize((int)blockEntity2.getContainerSize(), (Object)ItemStack.EMPTY);
                container.copyInto(tempList);
                for (int i = 0; i < tempList.size(); ++i) {
                    blockEntity2.setItem(i, (ItemStack)tempList.get(i));
                }
            }
            if (placer != null) {
                blockEntity2.setPlacerUUID(placer.getUUID());
            }
            blockEntity2.setTargetYaw(0.0f);
            blockEntity2.setChanged();
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CrossbowTurretBlockEntity) {
            CrossbowTurretBlockEntity turretEntity = (CrossbowTurretBlockEntity)blockEntity;
            boolean hasContents = false;
            ArrayList<ItemStack> itemsList = new ArrayList<ItemStack>();
            for (int i = 0; i < turretEntity.getContainerSize(); ++i) {
                ItemStack slotStack = turretEntity.getItem(i);
                itemsList.add(slotStack);
                if (slotStack.isEmpty()) continue;
                hasContents = true;
            }
            ItemEnchantments enchantments = turretEntity.getEnchantments();
            if (enchantments != null && !enchantments.isEmpty()) {
                hasContents = true;
            }
            if (!player.isCreative() || hasContents) {
                ItemStack itemstack = new ItemStack((ItemLike)this);
                if (enchantments != null && !enchantments.isEmpty()) {
                    itemstack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
                }
                if (hasContents) {
                    ItemContainerContents contents = ItemContainerContents.fromItems(itemsList);
                    itemstack.set(DataComponents.CONTAINER, (Object)contents);
                }
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
            turretEntity.clearContent();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return List.of();
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        Level actualLevel;
        BlockEntity blockEntity;
        ItemStack stack = super.getCloneItemStack(level, pos, state, includeData);
        if (includeData && level instanceof Level && (blockEntity = (actualLevel = (Level)level).getBlockEntity(pos)) instanceof CrossbowTurretBlockEntity) {
            CrossbowTurretBlockEntity turretEntity = (CrossbowTurretBlockEntity)blockEntity;
            ItemEnchantments enchantments = turretEntity.getEnchantments();
            if (enchantments != null && !enchantments.isEmpty()) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
            }
            ArrayList<ItemStack> itemsList = new ArrayList<ItemStack>();
            boolean hasItems = false;
            for (int i = 0; i < turretEntity.getContainerSize(); ++i) {
                ItemStack slotStack = turretEntity.getItem(i);
                itemsList.add(slotStack);
                if (slotStack.isEmpty()) continue;
                hasItems = true;
            }
            if (hasItems) {
                ItemContainerContents contents = ItemContainerContents.fromItems(itemsList);
                stack.set(DataComponents.CONTAINER, (Object)contents);
            }
        }
        return stack;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
    }
}

