/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block.entity;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.entity.ModBlockEntities;
import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.gui.CrossbowPresetWorkbenchMenu;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.PresetListSyncS2CPacket;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetCodec;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetManager;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetSavedData;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.PresetCrossbowRegistry;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.extensions.IMenuProviderExtension;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrossbowPresetWorkbenchBlockEntity
extends BaseContainerBlockEntity
implements IMenuProviderExtension {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private String currentEncodedString = "";
    private String currentPresetName = "";
    private boolean addToLootPool = false;

    public CrossbowPresetWorkbenchBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CROSSBOW_PRESET_WORKBENCH.get(), pos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.mafishcrossbow.crossbow_preset_workbench");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        Player player = playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendPresetListToPlayer(serverPlayer);
        }
        return new CrossbowPresetWorkbenchMenu(containerId, playerInventory, this);
    }

    public void sendPresetListToPlayer(ServerPlayer player) {
        ArrayList<PresetListSyncS2CPacket.PresetInfo> presetInfos = new ArrayList<PresetListSyncS2CPacket.PresetInfo>();
        List<CrossbowPresetSavedData.PresetEntry> playerPresets = this.getAllPresets();
        for (CrossbowPresetSavedData.PresetEntry p : playerPresets) {
            presetInfos.add(new PresetListSyncS2CPacket.PresetInfo(p.name, p.addToLootPool, false, false));
        }
        List<PresetCrossbowRegistry.PresetCrossbow> builtInPresets = PresetCrossbowRegistry.getAllPresets((Player)player);
        for (PresetCrossbowRegistry.PresetCrossbow preset : builtInPresets) {
            presetInfos.add(new PresetListSyncS2CPacket.PresetInfo(preset.getDisplayName(), true, true, preset.isDynamic()));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PresetListSyncS2CPacket(presetInfos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.getBlockPos());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getContainerSize() {
        return 2;
    }

    public String encodeInputCrossbow() {
        ItemStack input = (ItemStack)this.items.get(1);
        if (input.isEmpty()) {
            MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u8f93\u5165\u69fd\u4e3a\u7a7a");
            return null;
        }
        if (input.getItem() != Items.CROSSBOW) {
            MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u8f93\u5165\u69fd\u4e0d\u662f\u5f29");
            return null;
        }
        try {
            String encoded;
            this.currentEncodedString = encoded = CrossbowPresetCodec.encode(input, this.level);
            if (input.has(DataComponents.CUSTOM_NAME)) {
                this.currentPresetName = input.getHoverName().getString();
            }
            this.setChanged();
            this.syncToClient();
            MafishCrossbow.LOGGER.info("[PresetWorkbench] \u7f16\u7801\u6210\u529f: {}", (Object)encoded);
            return encoded;
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("[PresetWorkbench] \u7f16\u7801\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String getInputCrossbowName() {
        ItemStack input = (ItemStack)this.items.get(1);
        if (!input.isEmpty() && input.getItem() == Items.CROSSBOW) {
            return input.getHoverName().getString();
        }
        return "";
    }

    public boolean decodeToOutputSlot(String encodedString) {
        if (!CrossbowPresetCodec.isValidEncoded(encodedString)) {
            MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u65e0\u6548\u7684\u7f16\u7801\u5b57\u7b26\u4e32");
            return false;
        }
        if (this.level == null || this.level.isClientSide) {
            return false;
        }
        try {
            ItemStack decoded = CrossbowPresetCodec.decode(encodedString, this.level);
            if (decoded.isEmpty()) {
                MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u89e3\u7801\u7ed3\u679c\u4e3a\u7a7a");
                return false;
            }
            this.items.set(0, (Object)decoded);
            this.currentEncodedString = encodedString;
            this.setChanged();
            this.syncToClient();
            MafishCrossbow.LOGGER.info("[PresetWorkbench] \u89e3\u7801\u6210\u529f");
            return true;
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("[PresetWorkbench] \u89e3\u7801\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean savePreset(String name, boolean addToLootPool) {
        if (this.currentEncodedString.isEmpty()) {
            MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u6ca1\u6709\u53ef\u4fdd\u5b58\u7684\u7f16\u7801");
            return false;
        }
        if (name == null || name.trim().isEmpty()) {
            MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u9884\u8bbe\u540d\u79f0\u4e3a\u7a7a");
            return false;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CrossbowPresetManager.savePreset(serverLevel, name.trim(), this.currentEncodedString, addToLootPool);
        this.currentPresetName = name.trim();
        this.addToLootPool = addToLootPool;
        this.setChanged();
        this.syncToClient();
        MafishCrossbow.LOGGER.info("[PresetWorkbench] \u9884\u8bbe\u5df2\u4fdd\u5b58: {}, \u52a0\u5165\u6389\u843d\u6c60: {}", (Object)name, (Object)addToLootPool);
        return true;
    }

    public boolean loadPreset(String name) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack crossbow = CrossbowPresetManager.loadPreset(serverLevel, name);
        if (crossbow == null || crossbow.isEmpty()) {
            MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u9884\u8bbe\u4e0d\u5b58\u5728\u6216\u52a0\u8f7d\u5931\u8d25: {}", (Object)name);
            return false;
        }
        String encoded = CrossbowPresetManager.getPresetEncodedString(serverLevel, name);
        if (encoded != null) {
            this.currentEncodedString = encoded;
        }
        this.items.set(0, (Object)crossbow);
        this.currentPresetName = name;
        this.setChanged();
        this.syncToClient();
        MafishCrossbow.LOGGER.info("[PresetWorkbench] \u9884\u8bbe\u5df2\u52a0\u8f7d: {}", (Object)name);
        return true;
    }

    public boolean loadBuiltinPreset(String name, Player player) {
        List<PresetCrossbowRegistry.PresetCrossbow> builtInPresets = PresetCrossbowRegistry.getAllPresets(player);
        for (PresetCrossbowRegistry.PresetCrossbow preset : builtInPresets) {
            if (!preset.getDisplayName().equals(name)) continue;
            ItemStack crossbow = preset.getCrossbow();
            if (crossbow.isEmpty()) {
                MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u786c\u7f16\u7801\u9884\u8bbe\u5f29\u4e3a\u7a7a: {}", (Object)name);
                return false;
            }
            Integer voidDepth = (Integer)crossbow.get(ModDataConponents.VOID_DEPTH.get());
            MafishCrossbow.LOGGER.info("[PresetWorkbench] \u5f29 VOID_DEPTH: {}", (Object)voidDepth);
            this.items.set(0, (Object)crossbow);
            this.currentPresetName = name;
            this.currentEncodedString = "";
            this.setChanged();
            this.syncToClient();
            MafishCrossbow.LOGGER.info("[PresetWorkbench] \u786c\u7f16\u7801\u9884\u8bbe\u5df2\u52a0\u8f7d: {}", (Object)name);
            return true;
        }
        MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u786c\u7f16\u7801\u9884\u8bbe\u4e0d\u5b58\u5728: {}", (Object)name);
        return false;
    }

    public boolean deletePreset(String name) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean success = CrossbowPresetManager.deletePreset(serverLevel, name);
        if (success) {
            MafishCrossbow.LOGGER.info("[PresetWorkbench] \u9884\u8bbe\u5df2\u5220\u9664: {}", (Object)name);
        }
        return success;
    }

    public List<CrossbowPresetSavedData.PresetEntry> getAllPresets() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return new ArrayList<CrossbowPresetSavedData.PresetEntry>();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Collection<CrossbowPresetSavedData.PresetEntry> presets = CrossbowPresetManager.getAllPresets(serverLevel);
        return new ArrayList<CrossbowPresetSavedData.PresetEntry>(presets);
    }

    public boolean setPresetLootPoolStatus(String name, boolean addToLootPool) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return CrossbowPresetManager.setLootPoolStatus(serverLevel, name, addToLootPool);
    }

    public String getCurrentEncodedString() {
        return this.currentEncodedString;
    }

    public void setCurrentEncodedString(String encodedString) {
        this.currentEncodedString = encodedString;
        this.setChanged();
        this.syncToClient();
    }

    public String getCurrentPresetName() {
        return this.currentPresetName;
    }

    public void setCurrentPresetName(String presetName) {
        this.currentPresetName = presetName;
        this.setChanged();
    }

    public boolean isAddToLootPool() {
        return this.addToLootPool;
    }

    public void setAddToLootPool(boolean addToLootPool) {
        this.addToLootPool = addToLootPool;
        this.setChanged();
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        ContainerHelper.saveAllItems((ValueOutput)out, this.items);
        out.store("encoded_string", (Codec)Codec.STRING, (Object)this.currentEncodedString);
        out.store("preset_name", (Codec)Codec.STRING, (Object)this.currentPresetName);
        out.store("add_to_loot_pool", (Codec)Codec.BOOL, (Object)this.addToLootPool);
    }

    protected void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)in, this.items);
        this.currentEncodedString = in.read("encoded_string", (Codec)Codec.STRING).orElse("");
        this.currentPresetName = in.read("preset_name", (Codec)Codec.STRING).orElse("");
        this.addToLootPool = in.read("add_to_loot_pool", (Codec)Codec.BOOL).orElse(false);
    }

    private void syncToClient() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = this.saveCustomOnly(registries);
        tag.putString("encoded_string", this.currentEncodedString);
        tag.putString("preset_name", this.currentPresetName);
        tag.putBoolean("add_to_loot_pool", this.addToLootPool);
        return tag;
    }
}

