/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block.entity;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.CrossbowTurretBlock;
import com.mafuyu33.mafishcrossbow.block.entity.ModBlockEntities;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.gui.CrossbowTurretMenu;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.CrossbowProjectileStrategyHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.common.extensions.IMenuProviderExtension;
import org.jetbrains.annotations.Nullable;

public class CrossbowTurretBlockEntity
extends BaseContainerBlockEntity
implements IMenuProviderExtension {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    private UUID placerUUID;
    private UUID turretUUID = UUID.randomUUID();
    private int fireCooldown = 0;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;
    private int mode = 0;
    private boolean isCharged = false;
    private boolean enabled = false;
    private boolean hasTarget = false;
    private int targetType = 0;
    private float fixedYaw = 0.0f;
    private float fixedPitch = 0.0f;
    private float renderOffsetX = 0.0f;
    private float renderOffsetY = 0.0f;
    private float renderOffsetZ = 0.0f;
    private float renderRotationX = 90.0f;
    private float renderRotationY = 90.0f;
    private float renderRotationZ = -45.0f;
    private float renderScale = 2.0f;
    private static final int FIRE_RATE = 20;
    private static final int CHARGE_TIME = 15;
    private static final double TARGET_RANGE = 32.0;

    public CrossbowTurretBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CROSSBOW_TURRET.get(), pos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.mafishcrossbow.crossbow_turret");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        return new CrossbowTurretMenu(containerId, playerInventory, this);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.getBlockPos());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getContainerSize() {
        return 9;
    }

    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    public void setPlacerUUID(UUID uuid) {
        this.placerUUID = uuid;
        this.setChanged();
    }

    public UUID getPlacerUUID() {
        return this.placerUUID;
    }

    public UUID getTurretUUID() {
        return this.turretUUID;
    }

    public float getTargetYaw() {
        return this.targetYaw;
    }

    public void setTargetYaw(float yaw) {
        this.targetYaw = yaw;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public float getTargetPitch() {
        return this.targetPitch;
    }

    public void setTargetPitch(float pitch) {
        this.targetPitch = pitch;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setTargetYawPitch(float yaw, float pitch) {
        this.targetYaw = yaw;
        this.targetPitch = pitch;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.targetYaw = 0.0f;
            this.targetPitch = 0.0f;
            this.fixedYaw = 0.0f;
            this.fixedPitch = 0.0f;
            this.hasTarget = mode != 1;
        }
        this.mode = mode;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public float getFixedYaw() {
        return this.fixedYaw;
    }

    public void setFixedYaw(float yaw) {
        this.fixedYaw = yaw;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public float getFixedPitch() {
        return this.fixedPitch;
    }

    public void setFixedPitch(float pitch) {
        this.fixedPitch = pitch;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isCharged() {
        return this.isCharged;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public float getRenderOffsetX() {
        return this.renderOffsetX;
    }

    public float getRenderOffsetY() {
        return this.renderOffsetY;
    }

    public float getRenderOffsetZ() {
        return this.renderOffsetZ;
    }

    public float getRenderRotationX() {
        return this.renderRotationX;
    }

    public float getRenderRotationY() {
        return this.renderRotationY;
    }

    public float getRenderRotationZ() {
        return this.renderRotationZ;
    }

    public float getRenderScale() {
        return this.renderScale;
    }

    public void setRenderOffset(float x, float y, float z) {
        this.renderOffsetX = x;
        this.renderOffsetY = y;
        this.renderOffsetZ = z;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setRenderRotation(float x, float y, float z) {
        this.renderRotationX = x;
        this.renderRotationY = y;
        this.renderRotationZ = z;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setRenderScale(float scale) {
        this.renderScale = scale;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        if (!this.enchantments.isEmpty()) {
            out.store("mafishcrossbow_enchantments", ItemEnchantments.CODEC, (Object)this.enchantments);
        }
        if (this.placerUUID != null) {
            out.store("mafishcrossbow_placer", UUIDUtil.CODEC, (Object)this.placerUUID);
        }
        if (this.turretUUID != null) {
            out.store("mafishcrossbow_turret_uuid", UUIDUtil.CODEC, (Object)this.turretUUID);
        }
        out.store("mafishcrossbow_fire_cooldown", ExtraCodecs.NON_NEGATIVE_INT, (Object)this.fireCooldown);
        out.store("mafishcrossbow_target_yaw", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.targetYaw));
        out.store("mafishcrossbow_target_pitch", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.targetPitch));
        out.store("mafishcrossbow_mode", ExtraCodecs.NON_NEGATIVE_INT, (Object)this.mode);
        out.store("mafishcrossbow_charged", (Codec)Codec.BOOL, (Object)this.isCharged);
        out.store("mafishcrossbow_enabled", (Codec)Codec.BOOL, (Object)this.enabled);
        out.store("mafishcrossbow_target_type", ExtraCodecs.NON_NEGATIVE_INT, (Object)this.targetType);
        out.store("mafishcrossbow_fixed_yaw", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.fixedYaw));
        out.store("mafishcrossbow_fixed_pitch", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.fixedPitch));
        out.store("renderOffsetX", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderOffsetX));
        out.store("renderOffsetY", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderOffsetY));
        out.store("renderOffsetZ", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderOffsetZ));
        out.store("renderRotationX", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderRotationX));
        out.store("renderRotationY", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderRotationY));
        out.store("renderRotationZ", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderRotationZ));
        out.store("renderScale", (Codec)Codec.FLOAT, (Object)Float.valueOf(this.renderScale));
        ContainerHelper.saveAllItems((ValueOutput)out, this.items);
    }

    protected void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.enchantments = in.read("mafishcrossbow_enchantments", ItemEnchantments.CODEC).orElse(ItemEnchantments.EMPTY);
        this.placerUUID = in.read("mafishcrossbow_placer", UUIDUtil.CODEC).orElse(null);
        this.turretUUID = in.read("mafishcrossbow_turret_uuid", UUIDUtil.CODEC).orElse(UUID.randomUUID());
        this.fireCooldown = in.read("mafishcrossbow_fire_cooldown", ExtraCodecs.NON_NEGATIVE_INT).orElse(0);
        this.targetYaw = in.read("mafishcrossbow_target_yaw", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.targetPitch = in.read("mafishcrossbow_target_pitch", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.mode = in.read("mafishcrossbow_mode", ExtraCodecs.NON_NEGATIVE_INT).orElse(0);
        this.isCharged = in.read("mafishcrossbow_charged", (Codec)Codec.BOOL).orElse(false);
        this.enabled = in.read("mafishcrossbow_enabled", (Codec)Codec.BOOL).orElse(false);
        this.targetType = in.read("mafishcrossbow_target_type", ExtraCodecs.NON_NEGATIVE_INT).orElse(0);
        this.fixedYaw = in.read("mafishcrossbow_fixed_yaw", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.fixedPitch = in.read("mafishcrossbow_fixed_pitch", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)in, this.items);
        in.read("targetYaw", (Codec)Codec.FLOAT).ifPresent(yaw -> {
            this.targetYaw = yaw.floatValue();
        });
        in.read("targetPitch", (Codec)Codec.FLOAT).ifPresent(pitch -> {
            this.targetPitch = pitch.floatValue();
        });
        in.read("isCharged", (Codec)Codec.BOOL).ifPresent(charged -> {
            this.isCharged = charged;
        });
        in.read("enabled", (Codec)Codec.BOOL).ifPresent(e -> {
            this.enabled = e;
        });
        in.read("targetType", ExtraCodecs.NON_NEGATIVE_INT).ifPresent(type -> {
            this.targetType = type;
        });
        in.read("fixedYaw", (Codec)Codec.FLOAT).ifPresent(yaw -> {
            this.fixedYaw = yaw.floatValue();
        });
        in.read("fixedPitch", (Codec)Codec.FLOAT).ifPresent(pitch -> {
            this.fixedPitch = pitch.floatValue();
        });
        this.renderOffsetX = in.read("renderOffsetX", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.renderOffsetY = in.read("renderOffsetY", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.renderOffsetZ = in.read("renderOffsetZ", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.0f)).floatValue();
        this.renderRotationX = in.read("renderRotationX", (Codec)Codec.FLOAT).orElse(Float.valueOf(90.0f)).floatValue();
        this.renderRotationY = in.read("renderRotationY", (Codec)Codec.FLOAT).orElse(Float.valueOf(90.0f)).floatValue();
        this.renderRotationZ = in.read("renderRotationZ", (Codec)Codec.FLOAT).orElse(Float.valueOf(-45.0f)).floatValue();
        this.renderScale = in.read("renderScale", (Codec)Codec.FLOAT).orElse(Float.valueOf(2.0f)).floatValue();
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = this.saveCustomOnly(registries);
        tag.putFloat("targetYaw", this.targetYaw);
        tag.putFloat("targetPitch", this.targetPitch);
        tag.putBoolean("isCharged", this.isCharged);
        tag.putBoolean("enabled", this.enabled);
        tag.putInt("targetType", this.targetType);
        tag.putFloat("fixedYaw", this.fixedYaw);
        tag.putFloat("fixedPitch", this.fixedPitch);
        tag.putFloat("renderOffsetX", this.renderOffsetX);
        tag.putFloat("renderOffsetY", this.renderOffsetY);
        tag.putFloat("renderOffsetZ", this.renderOffsetZ);
        tag.putFloat("renderRotationX", this.renderRotationX);
        tag.putFloat("renderRotationY", this.renderRotationY);
        tag.putFloat("renderRotationZ", this.renderRotationZ);
        tag.putFloat("renderScale", this.renderScale);
        return tag;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrossbowTurretBlockEntity blockEntity) {
        boolean success;
        boolean canFire;
        boolean hasAmmo;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean hasRedstoneSignal = level.hasNeighborSignal(pos);
        boolean hasInfinity = blockEntity.enchantments != null && blockEntity.enchantments.getLevel(level.holderOrThrow(Enchantments.INFINITY)) > 0;
        boolean bl = hasAmmo = hasInfinity || blockEntity.hasProjectiles();
        if (blockEntity.fireCooldown > 0) {
            --blockEntity.fireCooldown;
            if (blockEntity.fireCooldown == 5 && !blockEntity.isCharged && hasAmmo) {
                blockEntity.isCharged = true;
                blockEntity.setChanged();
                if (blockEntity.level != null && !blockEntity.level.isClientSide) {
                    blockEntity.level.sendBlockUpdated(blockEntity.worldPosition, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                }
            } else {
                blockEntity.setChanged();
            }
        } else if (!blockEntity.isCharged && hasAmmo) {
            blockEntity.fireCooldown = 20;
            blockEntity.setChanged();
        }
        if (blockEntity.mode == 1) {
            LivingEntity target = blockEntity.findNearestTarget(serverLevel, pos);
            if (target != null) {
                blockEntity.updateAimTowardsTarget(pos, target.position());
                float baseYaw = blockEntity.targetYaw;
                float basePitch = blockEntity.targetPitch;
                float finalYaw = baseYaw + blockEntity.fixedYaw;
                float finalPitch = basePitch + blockEntity.fixedPitch;
                blockEntity.targetYaw = finalYaw;
                blockEntity.targetPitch = finalPitch;
                blockEntity.setChanged();
                if (blockEntity.level != null && !blockEntity.level.isClientSide) {
                    blockEntity.level.sendBlockUpdated(blockEntity.worldPosition, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                }
                blockEntity.hasTarget = true;
            } else {
                if (blockEntity.targetYaw != blockEntity.fixedYaw || blockEntity.targetPitch != blockEntity.fixedPitch) {
                    blockEntity.targetYaw = blockEntity.fixedYaw;
                    blockEntity.targetPitch = blockEntity.fixedPitch;
                    blockEntity.setChanged();
                    if (blockEntity.level != null && !blockEntity.level.isClientSide) {
                        blockEntity.level.sendBlockUpdated(blockEntity.worldPosition, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                    }
                }
                blockEntity.hasTarget = false;
            }
        } else if (blockEntity.mode == 0) {
            blockEntity.hasTarget = true;
            if (blockEntity.targetYaw != blockEntity.fixedYaw || blockEntity.targetPitch != blockEntity.fixedPitch) {
                blockEntity.targetYaw = blockEntity.fixedYaw;
                blockEntity.targetPitch = blockEntity.fixedPitch;
                blockEntity.setChanged();
                if (blockEntity.level != null && !blockEntity.level.isClientSide) {
                    blockEntity.level.sendBlockUpdated(blockEntity.worldPosition, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                }
            }
        }
        boolean isEnabled = blockEntity.enabled || hasRedstoneSignal;
        boolean bl2 = canFire = isEnabled && blockEntity.fireCooldown <= 0 && blockEntity.isCharged;
        if (blockEntity.mode == 1) {
            boolean bl3 = canFire = canFire && blockEntity.hasTarget;
        }
        if (canFire && (success = blockEntity.tryFire(serverLevel, state, pos))) {
            blockEntity.fireCooldown = 20;
            blockEntity.isCharged = false;
            blockEntity.setChanged();
            if (blockEntity.level != null && !blockEntity.level.isClientSide) {
                blockEntity.level.sendBlockUpdated(blockEntity.worldPosition, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            }
        }
    }

    private boolean hasProjectiles() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private LivingEntity findNearestTarget(ServerLevel level, BlockPos pos) {
        Vec3 turretCenter = Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.45, 0.0);
        AABB searchBox = new AABB(turretCenter.subtract(32.0, 32.0, 32.0), turretCenter.add(32.0, 32.0, 32.0));
        boolean hasIntangible = this.enchantments != null && this.enchantments.getLevel(level.holderOrThrow(ModEnchantments.INTANGIBLE)) > 0;
        List entities = level.getEntitiesOfClass(LivingEntity.class, searchBox, entity -> {
            if (entity instanceof Player) {
                return false;
            }
            if (!entity.isAlive()) {
                return false;
            }
            return switch (this.targetType) {
                case 1 -> {
                    if (entity instanceof Enemy || entity.getType().getCategory() == MobCategory.MONSTER) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        });
        if (entities.isEmpty()) {
            return null;
        }
        LivingEntity nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (LivingEntity entity2 : entities) {
            Vec3 targetPos;
            Vec3 shootDirection;
            Vec3 spawnPos;
            BlockHitResult hitResult;
            double distance = entity2.distanceToSqr(turretCenter);
            if (distance >= minDistance || !hasIntangible && (hitResult = level.clip(new ClipContext(spawnPos = turretCenter.add((shootDirection = (targetPos = entity2.getEyePosition()).subtract(turretCenter).normalize()).scale(0.5)), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType() == HitResult.Type.BLOCK) continue;
            minDistance = distance;
            nearest = entity2;
        }
        return nearest;
    }

    private void updateAimTowardsTarget(BlockPos pos, Vec3 targetPos) {
        Vec3 turretPos = Vec3.atCenterOf((Vec3i)pos);
        Vec3 direction = targetPos.subtract(turretPos).normalize();
        float absoluteYaw = (float)Math.toDegrees(Math.atan2(-direction.x, direction.z));
        Direction facing = (Direction)this.getBlockState().getValue(CrossbowTurretBlock.FACING);
        Vec3 baseDirection = facing == Direction.EAST || facing == Direction.WEST ? new Vec3((double)(-facing.getStepX()), (double)facing.getStepY(), (double)facing.getStepZ()).normalize() : new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ()).normalize();
        float baseYaw = (float)Math.toDegrees(Math.atan2(-baseDirection.x, baseDirection.z));
        this.targetYaw = absoluteYaw - baseYaw;
        while (this.targetYaw > 180.0f) {
            this.targetYaw -= 360.0f;
        }
        while (this.targetYaw < -180.0f) {
            this.targetYaw += 360.0f;
        }
        this.targetPitch = (float)(-Math.toDegrees(Math.atan2(direction.y, direction.horizontalDistance())));
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private boolean tryFire(ServerLevel level, BlockState state, BlockPos pos) {
        boolean hasInfinity = this.enchantments != null && this.enchantments.getLevel(level.holderOrThrow(Enchantments.INFINITY)) > 0;
        int multishotLevel = this.enchantments != null ? this.enchantments.getLevel(level.holderOrThrow(Enchantments.MULTISHOT)) : 0;
        int projectileCount = 1 + multishotLevel * 2;
        float spreadAngle = (float)multishotLevel * 10.0f;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            Vec3 shootDirection;
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (this.mode == 1) {
                facing = (Direction)state.getValue(CrossbowTurretBlock.FACING);
                baseDirection = facing == Direction.EAST || facing == Direction.WEST ? new Vec3((double)(-facing.getStepX()), (double)facing.getStepY(), (double)facing.getStepZ()).normalize() : new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ()).normalize();
                baseYaw = (float)Math.toDegrees(Math.atan2(-baseDirection.x, baseDirection.z));
                totalYawRad = Math.toRadians(baseYaw + this.targetYaw);
                pitchRad = Math.toRadians(this.targetPitch);
                horizontalScale = Math.cos(pitchRad);
                shootDirection = new Vec3(-Math.sin(totalYawRad) * horizontalScale, -Math.sin(pitchRad), Math.cos(totalYawRad) * horizontalScale).normalize();
            } else {
                facing = (Direction)state.getValue(CrossbowTurretBlock.FACING);
                baseDirection = facing == Direction.EAST || facing == Direction.WEST ? new Vec3((double)(-facing.getStepX()), (double)facing.getStepY(), (double)facing.getStepZ()).normalize() : new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ()).normalize();
                baseYaw = (float)Math.toDegrees(Math.atan2(-baseDirection.x, baseDirection.z));
                totalYawRad = Math.toRadians(baseYaw + this.fixedYaw);
                pitchRad = Math.toRadians(this.fixedPitch);
                horizontalScale = Math.cos(pitchRad);
                shootDirection = new Vec3(-Math.sin(totalYawRad) * horizontalScale, -Math.sin(pitchRad), Math.cos(totalYawRad) * horizontalScale).normalize();
            }
            Vec3 spawnPos = Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.5, 0.0).add(shootDirection.scale(0.5));
            boolean anySuccess = false;
            for (int projectileIndex = 0; projectileIndex < projectileCount; ++projectileIndex) {
                Vec3 scatteredDirection;
                float angleOffset = 0.0f;
                if (projectileCount > 1) {
                    float step = spreadAngle / (float)(projectileCount - 1);
                    angleOffset = -spreadAngle / 2.0f + (float)projectileIndex * step;
                }
                if (!this.fireProjectile(level, pos, spawnPos, scatteredDirection = this.applyYawOffset(shootDirection, angleOffset), itemstack, hasInfinity)) continue;
                anySuccess = true;
            }
            if (!anySuccess) continue;
            if (!hasInfinity) {
                itemstack.shrink(1);
                this.setChanged();
            }
            return true;
        }
        return false;
    }

    private Vec3 applyYawOffset(Vec3 direction, float yawOffset) {
        if (yawOffset == 0.0f) {
            return direction;
        }
        float currentYaw = (float)Math.toDegrees(Math.atan2(-direction.x, direction.z));
        float currentPitch = (float)(-Math.toDegrees(Math.atan2(direction.y, direction.horizontalDistance())));
        float newYaw = currentYaw + yawOffset;
        double yawRad = Math.toRadians(newYaw);
        double pitchRad = Math.toRadians(currentPitch);
        double horizontalScale = Math.cos(pitchRad);
        return new Vec3(-Math.sin(yawRad) * horizontalScale, -Math.sin(pitchRad), Math.cos(yawRad) * horizontalScale).normalize();
    }

    private boolean fireProjectile(ServerLevel level, BlockPos pos, Vec3 spawnPos, Vec3 shootVec, ItemStack itemstack, boolean keepItem) {
        StaticShooterContext shooterContext;
        Projectile projectile;
        Entity entity;
        LivingEntity owner = null;
        if (this.placerUUID != null && (entity = level.getEntity(this.placerUUID)) instanceof LivingEntity) {
            LivingEntity living;
            owner = living = (LivingEntity)entity;
        }
        ItemStack turretAsWeapon = new ItemStack((ItemLike)Items.CROSSBOW);
        if (this.enchantments != null && !this.enchantments.isEmpty()) {
            turretAsWeapon.set(DataComponents.ENCHANTMENTS, (Object)this.enchantments);
        }
        if ((projectile = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile((Level)level, shooterContext = new StaticShooterContext(spawnPos, shootVec, owner), turretAsWeapon, itemstack)) != null) {
            if (keepItem) {
                InfinityHelper.markAsInfinitySource(projectile);
            }
            if (this.turretUUID != null) {
                CompoundTag tag = new CompoundTag();
                tag.putBoolean("turret_fired", true);
                tag.putLong("turret_uuid_most", this.turretUUID.getMostSignificantBits());
                tag.putLong("turret_uuid_least", this.turretUUID.getLeastSignificantBits());
                tag.putString("turret_dimension", level.dimension().location().toString());
                projectile.getPersistentData().merge(tag);
                MafishCrossbow.LOGGER.info("[Turret] \u70ae\u53f0\u53d1\u5c04\u6295\u5c04\u7269\u5e76\u6dfb\u52a0\u6807\u8bb0 - \u7c7b\u578b: {}, UUID: {}, \u7ef4\u5ea6: {}", new Object[]{projectile.getClass().getSimpleName(), this.turretUUID, level.dimension().location()});
            }
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            float yRot = (float)Math.toDegrees(Math.atan2(-shootVec.x, shootVec.z));
            float xRot = (float)(-Math.toDegrees(Math.atan2(shootVec.y, shootVec.horizontalDistance())));
            projectile.setYRot(yRot);
            projectile.setXRot(xRot);
            projectile.yRotO = yRot;
            projectile.xRotO = xRot;
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.shootFromRotation((Entity)(owner != null ? owner : projectile), xRot, yRot, 0.0f, 3.0f, 0.0f);
            } else if (projectile instanceof ThrowableProjectile) {
                ThrowableProjectile throwable = (ThrowableProjectile)projectile;
                throwable.shootFromRotation((Entity)(owner != null ? owner : throwable), xRot, yRot, 0.0f, 3.0f, 0.0f);
            } else {
                projectile.setDeltaMovement(shootVec.scale(3.0));
            }
            level.addFreshEntity((Entity)projectile);
            level.levelEvent(1004, pos, 0);
            return true;
        }
        return false;
    }
}

