/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block.entity;

import com.mafuyu33.mafishcrossbow.block.entity.ModBlockEntities;
import com.mafuyu33.mafishcrossbow.gui.EnchantmentTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTableBlockEntity
extends BlockEntity
implements MenuProvider {
    private final SimpleContainer container = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            EnchantmentTableBlockEntity.this.setChanged();
        }
    };

    public EnchantmentTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ENCHANTMENT_TABLE.get(), pos, state);
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack stack = this.container.getItem(i);
            if (stack.isEmpty()) continue;
            out.store("Item" + i, ItemStack.CODEC, (Object)stack);
        }
    }

    protected void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack stack = in.read("Item" + i, ItemStack.CODEC).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            this.container.setItem(i, stack);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.mafishcrossbow.enchantment_table");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new EnchantmentTableMenu(containerId, playerInventory, (Container)this.container);
    }

    public Container getContainer() {
        return this.container;
    }
}

