/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.block.renderer;

import com.mafuyu33.mafishcrossbow.block.CrossbowTurretBlock;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class CrossbowTurretRenderer
implements BlockEntityRenderer<CrossbowTurretBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final ShulkerModel shulkerModel;
    private final ModelPart shulkerHead;
    private static final ResourceLocation SHULKER_TEXTURE = Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION.texture().withPath(p -> "textures/" + p + ".png");

    public CrossbowTurretRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.shulkerModel = new ShulkerModel(context.bakeLayer(ModelLayers.SHULKER));
        this.shulkerHead = this.shulkerModel.root().getChild("head");
    }

    public void render(CrossbowTurretBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        this.renderShulkerBase(blockEntity, partialTick, poseStack, bufferSource, combinedLight);
        this.renderCrossbow(blockEntity, poseStack, bufferSource, combinedLight, combinedOverlay);
    }

    private void renderShulkerBase(CrossbowTurretBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        poseStack.pushPose();
        poseStack.translate(0.5f, -0.55f, 0.5f);
        Direction facing = (Direction)blockEntity.getBlockState().getValue(CrossbowTurretBlock.FACING);
        float baseYaw = facing.toYRot() + 180.0f;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(baseYaw));
        float yaw = blockEntity.getTargetYaw();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-yaw));
        float scale = 0.85f;
        poseStack.scale(scale, scale, scale);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SHULKER_TEXTURE));
        this.shulkerHead.render(poseStack, vertexConsumer, combinedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private void renderCrossbow(CrossbowTurretBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f + blockEntity.getRenderOffsetX(), 0.85f + blockEntity.getRenderOffsetY(), 0.5f + blockEntity.getRenderOffsetZ());
        Direction facing = (Direction)blockEntity.getBlockState().getValue(CrossbowTurretBlock.FACING);
        float baseYaw = facing.toYRot();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(baseYaw));
        float yaw = blockEntity.getTargetYaw();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-yaw));
        float pitch = blockEntity.getTargetPitch();
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(pitch));
        ItemStack crossbowStack = new ItemStack((ItemLike)Items.CROSSBOW);
        if (blockEntity.isCharged()) {
            ItemStack arrow = new ItemStack((ItemLike)Items.ARROW);
            crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(List.of(arrow)));
        }
        float scale = blockEntity.getRenderScale();
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(blockEntity.getRenderRotationX()));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f + blockEntity.getRenderRotationY()));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f + blockEntity.getRenderRotationZ()));
        this.itemRenderer.renderStatic(crossbowStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 128;
    }
}

