/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.client;

import com.mafuyu33.mafishcrossbow.entity.custom.BundleProjectile;
import com.mafuyu33.mafishcrossbow.entity.custom.CustomLightningBoltEntity;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.BundleProjectileS2CPacket;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.CrossbowOverloadNotice;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.CustomWindChargeS2CPacket;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.EntityVelocityUpdateS2CPacket;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.LightningPathSyncPacket;
import com.mafuyu33.mafishcrossbow.rougecraft.client.CurseEventScreen;
import com.mafuyu33.mafishcrossbow.rougecraft.gui.EnchantmentSelectionScreen;
import com.mafuyu33.mafishcrossbow.rougecraft.network.CurseEventS2CPacket;
import com.mafuyu33.mafishcrossbow.rougecraft.network.EnchantmentOptionsS2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleCrossbowOverloadNotice(CrossbowOverloadNotice payload, IPayloadContext context) {
        context.enqueueWork(() -> Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"\u4f60\u611f\u5230\u624b\u4e2d\u7684\u5f29\u53d1\u751f\u4e86\u4e00\u4e9b\u00a7kABC\u00a7r..."), true));
    }

    public static void handleCustomWindCharge(CustomWindChargeS2CPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            CustomWindChargeS2CPacket.CustomWindChargeData.set(payload.uuid, payload.radius);
            if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
                Minecraft.getInstance().level.playSound((Entity)Minecraft.getInstance().player, Minecraft.getInstance().player.blockPosition(), (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.NEUTRAL, 5.0f, 1.0f / ((float)Math.random() * 0.4f + 0.8f));
            }
        });
    }

    public static void handleEntityVelocityUpdate(EntityVelocityUpdateS2CPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (payload.id != -1 && Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(payload.id)) != null) {
                entity.setDeltaMovement(payload.finalVelocity);
            }
        });
    }

    public static void handleBundleProjectile(BundleProjectileS2CPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(payload.id)) instanceof BundleProjectile) {
                BundleProjectile bp = (BundleProjectile)entity;
                bp.init(payload.carriedBundle, payload.sourceCrossbow);
            }
        });
    }

    public static void handleLightningPathSync(LightningPathSyncPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(payload.entityId())) instanceof CustomLightningBoltEntity) {
                CustomLightningBoltEntity lightning = (CustomLightningBoltEntity)entity;
                lightning.setClientPathPoints(payload.pathPoints());
            }
        });
    }

    public static void handleEnchantmentOptions(EnchantmentOptionsS2CPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> Minecraft.getInstance().setScreen((Screen)new EnchantmentSelectionScreen(payload.reason(), payload.options())));
    }

    public static void handleCurseEvent(CurseEventS2CPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> Minecraft.getInstance().setScreen((Screen)new CurseEventScreen()));
    }
}

