/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.client;

import com.mafuyu33.mafishcrossbow.block.CrossbowTurretBlock;
import com.mafuyu33.mafishcrossbow.network.packet.C2S.TurretManualAimC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class TurretManualAimingHandler {
    private static boolean isActive = false;
    private static BlockPos turretPos = null;
    private static boolean hasShownHint = false;

    public static void startManualAiming(BlockPos pos) {
        isActive = true;
        turretPos = pos;
        hasShownHint = false;
    }

    public static void stopManualAiming() {
        isActive = false;
        turretPos = null;
    }

    public static boolean isActive() {
        return isActive;
    }

    public static void onClientTick() {
        if (!isActive || turretPos == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            TurretManualAimingHandler.stopManualAiming();
            return;
        }
        BlockState state = mc.level.getBlockState(turretPos);
        if (!(state.getBlock() instanceof CrossbowTurretBlock)) {
            TurretManualAimingHandler.stopManualAiming();
            return;
        }
        TurretManualAimingHandler.performRaycastAndSendUpdate(false);
        if (!hasShownHint && mc.player != null) {
            mc.player.displayClientMessage((Component)Component.translatable((String)"gui.mafishcrossbow.turret.manual_aim.hint"), true);
            hasShownHint = true;
        }
    }

    public static boolean onMouseClick(int button) {
        if (isActive && button == 1) {
            TurretManualAimingHandler.performRaycastAndSendUpdate(true);
            TurretManualAimingHandler.stopManualAiming();
            return true;
        }
        return false;
    }

    private static void performRaycastAndSendUpdate(boolean isConfirm) {
        Vec3 lookVec;
        Vec3 endPos;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null || turretPos == null) {
            return;
        }
        BlockState state = mc.level.getBlockState(turretPos);
        if (!(state.getBlock() instanceof CrossbowTurretBlock)) {
            return;
        }
        Vec3 eyePos = mc.player.getEyePosition(1.0f);
        BlockHitResult hitResult = mc.level.clip(new ClipContext(eyePos, endPos = eyePos.add((lookVec = mc.player.getViewVector(1.0f)).scale(32.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)mc.player));
        Vec3 targetPos = hitResult.getType() != HitResult.Type.MISS ? hitResult.getLocation() : endPos;
        float[] angles = TurretManualAimingHandler.calculateAngles(state, targetPos);
        float relativeYaw = angles[0];
        float relativePitch = angles[1];
        TurretManualAimC2SPacket packet = new TurretManualAimC2SPacket(turretPos, relativeYaw, relativePitch, isConfirm);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static float[] calculateAngles(BlockState state, Vec3 targetPos) {
        Direction facing = (Direction)state.getValue(CrossbowTurretBlock.FACING);
        Vec3 turretCenter = Vec3.atCenterOf((Vec3i)turretPos).add(0.0, 0.5, 0.0);
        Vec3 direction = targetPos.subtract(turretCenter).normalize();
        double absoluteYaw = Math.toDegrees(Math.atan2(-direction.x, direction.z));
        double horizontalDistance = Math.sqrt(direction.x * direction.x + direction.z * direction.z);
        double absolutePitch = -Math.toDegrees(Math.atan2(direction.y, horizontalDistance));
        Vec3 baseDirection = TurretManualAimingHandler.getBaseDirection(facing);
        double baseYaw = Math.toDegrees(Math.atan2(-baseDirection.x, baseDirection.z));
        float relativeYaw = (float)TurretManualAimingHandler.normalizeAngle(absoluteYaw - baseYaw);
        float relativePitch = (float)absolutePitch;
        relativeYaw = Math.max(-180.0f, Math.min(180.0f, relativeYaw));
        relativePitch = Math.max(-90.0f, Math.min(90.0f, relativePitch));
        return new float[]{relativeYaw, relativePitch};
    }

    private static Vec3 getBaseDirection(Direction facing) {
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return new Vec3((double)(-facing.getStepX()), 0.0, (double)facing.getStepZ()).normalize();
        }
        return new Vec3((double)facing.getStepX(), 0.0, (double)facing.getStepZ()).normalize();
    }

    private static double normalizeAngle(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }
}

