/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.command;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetCodec;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CrossbowPresetCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"crossbow_preset").then(Commands.literal((String)"encode").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity patt0$temp = source.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                source.sendFailure((Component)Component.literal((String)"\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ItemStack mainHand = player.getMainHandItem();
            if (!(mainHand.getItem() instanceof CrossbowItem)) {
                source.sendFailure((Component)Component.literal((String)"\u8bf7\u624b\u6301\u5f29\uff01"));
                return 0;
            }
            try {
                String encoded = CrossbowPresetCodec.encode(mainHand, (Level)player.level());
                MafishCrossbow.LOGGER.info("=== \u5f29\u7f16\u7801\u7ed3\u679c ===");
                MafishCrossbow.LOGGER.info("\u7f16\u7801\u957f\u5ea6: {} \u5b57\u7b26", (Object)encoded.length());
                MafishCrossbow.LOGGER.info("\u7f16\u7801\u5185\u5bb9: {}", (Object)encoded);
                source.sendSuccess(() -> Component.literal((String)("\u7f16\u7801\u6210\u529f\uff01\u957f\u5ea6: " + encoded.length() + " \u5b57\u7b26")).withStyle(Style.EMPTY.withColor(0x55FF55)), false);
                if (encoded.length() > 200) {
                    source.sendSuccess(() -> Component.literal((String)"\u63d0\u793a: \u7f16\u7801\u8f83\u957f\uff0c\u89e3\u7801\u65f6\u8bf7\u4f7f\u7528\u5206\u6bb5\u8f93\u5165").withStyle(Style.EMPTY.withColor(0xFFFF55)), false);
                    source.sendSuccess(() -> Component.literal((String)"\u53c2\u8003: /crossbow_preset help").withStyle(Style.EMPTY.withColor(0xAAAAAA)), false);
                }
                MutableComponent clickableCode = Component.literal((String)encoded).withStyle(Style.EMPTY.withColor(0xAAAAAA).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(encoded)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"\u70b9\u51fb\u590d\u5236\u5230\u526a\u8d34\u677f"))));
                source.sendSuccess(() -> CrossbowPresetCommand.lambda$register$3((Component)clickableCode), false);
                return 1;
            }
            catch (Exception e) {
                source.sendFailure((Component)Component.literal((String)("\u7f16\u7801\u5931\u8d25: " + e.getMessage())));
                MafishCrossbow.LOGGER.error("\u7f16\u7801\u5f29\u5931\u8d25", (Throwable)e);
                return 0;
            }
        }))).then(Commands.literal((String)"decode").then(Commands.argument((String)"code", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity patt0$temp = source.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                source.sendFailure((Component)Component.literal((String)"\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            String code = StringArgumentType.getString((CommandContext)context, (String)"code");
            return CrossbowPresetCommand.decodeAndGive(source, player, code);
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"buffer").then(Commands.literal((String)"add").then(Commands.argument((String)"fragment", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity patt0$temp = source.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                source.sendFailure((Component)Component.literal((String)"\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            String fragment = StringArgumentType.getString((CommandContext)context, (String)"fragment");
            CrossbowPresetManager.appendToBuffer(player.getUUID(), fragment);
            int totalLength = CrossbowPresetManager.getBufferLength(player.getUUID());
            source.sendSuccess(() -> Component.literal((String)("\u5df2\u8ffd\u52a0 " + fragment.length() + " \u5b57\u7b26\uff0c\u7f13\u51b2\u533a\u603b\u957f\u5ea6: " + totalLength)).withStyle(Style.EMPTY.withColor(0x55FF55)), false);
            return 1;
        })))).then(Commands.literal((String)"decode").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity patt0$temp = source.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                source.sendFailure((Component)Component.literal((String)"\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (!CrossbowPresetManager.hasBuffer(player.getUUID())) {
                source.sendFailure((Component)Component.literal((String)"\u7f13\u51b2\u533a\u4e3a\u7a7a\uff01\u8bf7\u5148\u4f7f\u7528 /crossbow_preset buffer add <\u7247\u6bb5> \u6dfb\u52a0\u7f16\u7801"));
                return 0;
            }
            String code = CrossbowPresetManager.getBuffer(player.getUUID());
            int result = CrossbowPresetCommand.decodeAndGive(source, player, code);
            if (result == 1) {
                CrossbowPresetManager.clearBuffer(player.getUUID());
            }
            return result;
        }))).then(Commands.literal((String)"clear").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity patt0$temp = source.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                source.sendFailure((Component)Component.literal((String)"\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            CrossbowPresetManager.clearBuffer(player.getUUID());
            source.sendSuccess(() -> Component.literal((String)"\u7f13\u51b2\u533a\u5df2\u6e05\u7a7a").withStyle(Style.EMPTY.withColor(0x55FF55)), false);
            return 1;
        }))).then(Commands.literal((String)"show").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity patt0$temp = source.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                source.sendFailure((Component)Component.literal((String)"\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            int length = CrossbowPresetManager.getBufferLength(player.getUUID());
            if (length == 0) {
                source.sendSuccess(() -> Component.literal((String)"\u7f13\u51b2\u533a\u4e3a\u7a7a").withStyle(Style.EMPTY.withColor(0xAAAAAA)), false);
            } else {
                String buffer = CrossbowPresetManager.getBuffer(player.getUUID());
                String preview = buffer.length() > 50 ? buffer.substring(0, 50) + "..." : buffer;
                source.sendSuccess(() -> Component.literal((String)("\u7f13\u51b2\u533a\u957f\u5ea6: " + length + " \u5b57\u7b26")).withStyle(Style.EMPTY.withColor(0x55FF55)), false);
                source.sendSuccess(() -> Component.literal((String)("\u9884\u89c8: " + preview)).withStyle(Style.EMPTY.withColor(0xAAAAAA)), false);
                boolean valid = CrossbowPresetCodec.isValidEncoded(buffer);
                source.sendSuccess(() -> Component.literal((String)("\u683c\u5f0f: " + (valid ? "\u6709\u6548" : "\u65e0\u6548/\u4e0d\u5b8c\u6574"))).withStyle(Style.EMPTY.withColor(valid ? 0x55FF55 : 0xFF5555)), false);
            }
            return 1;
        })))).then(Commands.literal((String)"validate").then(Commands.argument((String)"code", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            String code = StringArgumentType.getString((CommandContext)context, (String)"code");
            if (CrossbowPresetCodec.isValidEncoded(code)) {
                source.sendSuccess(() -> Component.literal((String)"\u7f16\u7801\u683c\u5f0f\u6709\u6548\uff01").withStyle(Style.EMPTY.withColor(0x55FF55)), false);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)"\u7f16\u7801\u683c\u5f0f\u65e0\u6548\uff01"));
            return 0;
        })))).then(Commands.literal((String)"debug").then(Commands.argument((String)"code", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            String code = StringArgumentType.getString((CommandContext)context, (String)"code");
            if (!CrossbowPresetCodec.isValidEncoded(code)) {
                source.sendFailure((Component)Component.literal((String)"\u65e0\u6548\u7684\u7f16\u7801\u5b57\u7b26\u4e32\uff01"));
                return 0;
            }
            try {
                String json = CrossbowPresetCodec.decodeToJson(code);
                MafishCrossbow.LOGGER.info("=== \u89e3\u7801JSON ===\n{}", (Object)json);
                source.sendSuccess(() -> Component.literal((String)"JSON\u5df2\u8f93\u51fa\u5230\u65e5\u5fd7\u6587\u4ef6").withStyle(Style.EMPTY.withColor(0x55FF55)), false);
                String preview = json.length() > 200 ? json.substring(0, 200) + "..." : json;
                source.sendSuccess(() -> Component.literal((String)preview).withStyle(Style.EMPTY.withColor(0xAAAAAA)), false);
                return 1;
            }
            catch (Exception e) {
                source.sendFailure((Component)Component.literal((String)("\u89e3\u6790\u5931\u8d25: " + e.getMessage())));
                MafishCrossbow.LOGGER.error("Debug\u89e3\u6790\u5931\u8d25", (Throwable)e);
                return 0;
            }
        })))).then(Commands.literal((String)"help").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            source.sendSuccess(() -> Component.literal((String)"=== \u5f29\u9884\u8bbe\u547d\u4ee4\u5e2e\u52a9 ===").withStyle(Style.EMPTY.withColor(0xFFFF55).withBold(Boolean.valueOf(true))), false);
            source.sendSuccess(() -> Component.literal((String)"\u57fa\u672c\u547d\u4ee4:").withStyle(Style.EMPTY.withColor(0x55FFFF)), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset encode").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u7f16\u7801\u624b\u6301\u7684\u5f29").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset decode <\u7f16\u7801>").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u89e3\u7801\u5e76\u83b7\u5f97\u5f29\uff08\u77ed\u7f16\u7801\uff09").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"\u5206\u6bb5\u8f93\u5165\uff08\u957f\u7f16\u7801\uff09:").withStyle(Style.EMPTY.withColor(0x55FFFF)), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset buffer add <\u7247\u6bb5>").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u8ffd\u52a0\u7f16\u7801\u7247\u6bb5").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset buffer decode").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u89e3\u7801\u7f13\u51b2\u533a\u5185\u5bb9").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset buffer show").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u67e5\u770b\u7f13\u51b2\u533a\u72b6\u6001").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset buffer clear").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u6e05\u7a7a\u7f13\u51b2\u533a").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"\u5176\u4ed6:").withStyle(Style.EMPTY.withColor(0x55FFFF)), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset validate <\u7f16\u7801>").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u9a8c\u8bc1\u7f16\u7801\u683c\u5f0f").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            source.sendSuccess(() -> Component.literal((String)"/crossbow_preset debug <\u7f16\u7801>").withStyle(Style.EMPTY.withColor(0xAAAAAA)).append((Component)Component.literal((String)" - \u663e\u793aJSON\uff08\u8c03\u8bd5\uff09").withStyle(Style.EMPTY.withColor(0xFFFFFF))), false);
            return 1;
        }))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            source.sendSuccess(() -> Component.literal((String)"\u4f7f\u7528 /crossbow_preset help \u67e5\u770b\u5e2e\u52a9").withStyle(Style.EMPTY.withColor(0xFFFF55)), false);
            return 1;
        }));
    }

    private static int decodeAndGive(CommandSourceStack source, ServerPlayer player, String code) {
        if (!CrossbowPresetCodec.isValidEncoded(code)) {
            source.sendFailure((Component)Component.literal((String)"\u65e0\u6548\u7684\u7f16\u7801\u5b57\u7b26\u4e32\uff01\u5fc5\u987b\u4ee5 MCXB1: \u5f00\u5934"));
            source.sendFailure((Component)Component.literal((String)("\u63a5\u6536\u5230\u7684\u5b57\u7b26\u4e32\u957f\u5ea6: " + code.length())));
            return 0;
        }
        try {
            ItemStack crossbow = CrossbowPresetCodec.decode(code, (Level)player.level());
            if (!player.getInventory().add(crossbow)) {
                player.drop(crossbow, false);
            }
            String crossbowName = crossbow.getHoverName().getString();
            source.sendSuccess(() -> Component.literal((String)("\u89e3\u7801\u6210\u529f\uff01\u5df2\u7ed9\u4e88: " + crossbowName)).withStyle(Style.EMPTY.withColor(0x55FF55)), false);
            return 1;
        }
        catch (Exception e) {
            Throwable rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            String errorMsg = rootCause.getMessage() != null ? rootCause.getMessage() : e.getMessage();
            source.sendFailure((Component)Component.literal((String)("\u89e3\u7801\u5931\u8d25: " + errorMsg)));
            MafishCrossbow.LOGGER.error("\u89e3\u7801\u5f29\u5931\u8d25", (Throwable)e);
            return 0;
        }
    }

    private static /* synthetic */ Component lambda$register$3(Component clickableCode) {
        return Component.literal((String)"[\u70b9\u51fb\u590d\u5236] ").withStyle(Style.EMPTY.withColor(0xFFFF55)).append(clickableCode);
    }
}

