/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.bounce.BounceHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.piercing.PiercingHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.silktouch.SilkTouchHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.trail.TrailHelper;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class TrailEntity
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<String> TRAIL_TYPE = SynchedEntityData.defineId(TrailEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public TrailEntity(EntityType<? extends ThrowableItemProjectile> p_37442_, Level p_37443_) {
        super(p_37442_, p_37443_);
    }

    public TrailEntity(EntityType<? extends ThrowableItemProjectile> entityType, double x, double y, double z, Level level, ItemStack item) {
        super(entityType, x, y, z, level, item);
    }

    public TrailEntity(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity owner, Level level, ItemStack item) {
        super(entityType, owner, level, item);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            TrailHelper.spawnTrailParticles((Entity)this);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        SilkTouchHelper.SilkTouchResult silkTouchResult = SilkTouchHelper.onHitBlockWithResult((Entity)this, this.getPersistentData(), result);
        switch (silkTouchResult) {
            case PIERCE: {
                Vec3 movement = this.getDeltaMovement();
                Vec3 hitPos = result.getLocation();
                Vec3 newPos = hitPos.add(movement.normalize().scale(1.0));
                this.setPos(newPos);
                return;
            }
            case STOP: {
                if (BounceHelper.bounceWithCopy((Entity)this, this.getPersistentData(), result)) {
                    return;
                }
                return;
            }
        }
        super.onHitBlock(result);
        if (this.isRemoved()) {
            return;
        }
        this.afterHitBlock(result);
    }

    protected void afterHitBlock(BlockHitResult result) {
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (this.isRemoved()) {
            return;
        }
        this.onEntityImpact(result);
        PiercingHelper.recordPiercedEntity((Entity)this, result.getEntity().getId());
        if (PiercingHelper.hasPiercingTag((Entity)this) && !PiercingHelper.shouldDiscardAfterHit((Entity)this)) {
            return;
        }
        this.afterHitEntity(result);
    }

    protected void onEntityImpact(EntityHitResult result) {
    }

    protected void afterHitEntity(EntityHitResult result) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRAIL_TYPE, (Object)"transition");
    }

    public void setTrailType(String trailType) {
        this.entityData.set(TRAIL_TYPE, (Object)trailType);
    }

    public String getTrailType() {
        return (String)this.entityData.get(TRAIL_TYPE);
    }
}

