/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.item.ModItems;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;

public class AnyProjectile
extends TrailEntity {
    private static final int MAX_LIFETIME = 1200;
    private int lifetime = 0;
    private static final String TAG_ITEM = "StoredItem";
    private static final String TAG_DROP = "ShouldDrop";
    private boolean shouldDropOnHit = true;

    public AnyProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AnyProjectile(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity shooter, Level level, ItemStack ammo, ItemStack sourceCrossbow) {
        super(entityType, shooter, level, ammo);
        this.setItem(ammo.copy());
        ItemStack copy = ammo.copy();
        if (ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, sourceCrossbow) > 0) {
            this.shouldDropOnHit = false;
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @NotNull
    protected Item getDefaultItem() {
        return ModItems.MAFISH.asItem();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (InfinityHelper.hasInfinitySource((Projectile)this)) {
                this.shouldDropOnHit = false;
            }
            ++this.lifetime;
            int modifiedMaxLifetime = 1200;
            modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
            if (this.lifetime > (modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData()))) {
                if (this.shouldDropOnHit) {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem().copy()));
                }
                this.discard();
            }
        }
    }

    @Override
    protected void afterHitBlock(BlockHitResult hit) {
        FakePlayer player;
        if (this.level().isClientSide) {
            return;
        }
        ItemStack stack = this.getItem();
        Item item = stack.getItem();
        Entity owner = this.getOwner();
        ServerLevel world = (ServerLevel)this.level();
        if (owner instanceof Player) {
            Player p = (Player)owner;
            v0 = p;
        } else {
            v0 = player = FakePlayerFactory.getMinecraft((ServerLevel)world);
        }
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            boolean placed = bucket.emptyContents((LivingEntity)player, (Level)world, hit.getBlockPos().relative(hit.getDirection()), hit, stack);
            if (placed) {
                this.shouldDropOnHit = false;
                if (!InfinityHelper.hasInfinitySource((Projectile)this)) {
                    ItemStack result = BucketItem.getEmptySuccessItem((ItemStack)stack, (Player)player);
                    world.addFreshEntity((Entity)new ItemEntity((Level)world, this.getX(), this.getY(), this.getZ(), result));
                }
            }
        } else {
            UseOnContext ctx = new UseOnContext((Level)world, (Player)player, InteractionHand.MAIN_HAND, stack, hit);
            item.useOn(ctx);
        }
        if (this.shouldDropOnHit) {
            world.addFreshEntity((Entity)new ItemEntity((Level)world, this.getX(), this.getY(), this.getZ(), stack.copy()));
        }
        this.discard();
    }

    @Override
    protected void onEntityImpact(EntityHitResult hit) {
        Player real;
        if (this.level().isClientSide) {
            return;
        }
        ItemStack stack = this.getItem();
        Item item = stack.getItem();
        Object player = null;
        Entity owner = this.getOwner();
        player = owner instanceof Player ? (real = (Player)owner) : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.level()));
        Entity entity = hit.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = item.interactLivingEntity(stack, player, living, InteractionHand.MAIN_HAND);
        }
        float baseDamage = 1.0f;
        float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
        finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
        hit.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), finalDamage);
    }

    @Override
    protected void afterHitEntity(EntityHitResult hit) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack stack = this.getItem();
        if (this.shouldDropOnHit) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack.copy()));
        }
        this.discard();
    }

    protected void addAdditionalSaveData(ValueOutput out) {
        super.addAdditionalSaveData(out);
        out.store(TAG_ITEM, ItemStack.CODEC, (Object)this.getItem());
        out.putBoolean(TAG_DROP, this.shouldDropOnHit);
    }

    protected void readAdditionalSaveData(ValueInput in) {
        super.readAdditionalSaveData(in);
        ItemStack stack = in.read(TAG_ITEM, ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.setItem(stack);
        this.shouldDropOnHit = in.getBooleanOr(TAG_DROP, true);
    }
}

