/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.google.common.collect.Queues;
import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.CrossbowProjectileStrategyHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.leaky.LeakyHelper;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.BundleProjectileS2CPacket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class BundleProjectile
extends TrailEntity {
    private static final int MAX_LIFETIME = 1200;
    private int lifetime = 0;
    private boolean shouldDropOnHit = true;
    private int rocketAge;
    private ArrayDeque<ItemToEject> itemsToEject = Queues.newArrayDeque();
    private boolean serverInitialized = false;
    private boolean clientInitialized = false;
    private boolean hasBeenInitialized = false;
    private BundleContents originalContents = null;
    private static final float YAW_SPREAD_DEG = 40.0f;
    private static final float PITCH_SPREAD_DEG = 40.0f;
    private static final float SPEED_MIN = 0.8f;
    private static final float SPEED_MAX = 1.25f;
    private static final String TAG_BUNDLE = "CarriedBundle";
    private static final String TAG_DROP = "ShouldDrop";
    private static final String TAG_EJECT_QUEUE = "ItemsToEject";
    private static final String TAG_ROCKET_AGE = "RocketAge";
    private static final String TAG_LIFETIME = "Lifetime";
    private static final String TAG_INITIALIZED = "HasBeenInitialized";
    private static final String TAG_BUNDLE_CONTENTS = "BundleContentsBackup";

    public BundleProjectile(EntityType<? extends BundleProjectile> type, Level level) {
        super(type, level);
    }

    public BundleProjectile(Level level, LivingEntity shooter) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.BUNDLE_PROJECTILE.get()), level);
        this.setOwner((Entity)shooter);
        if (shooter != null) {
            this.setPos(shooter.getX(), shooter.getEyeY(), shooter.getZ());
        }
    }

    public static BundleProjectile create(Level level, LivingEntity shooter, ItemStack rawBundle, ItemStack rawCrossbow) {
        BundleProjectile proj = new BundleProjectile(level, shooter);
        ItemStack bundleSrv = rawBundle.copy();
        ItemStack xbowCopy = rawCrossbow.copy();
        proj.init(bundleSrv, xbowCopy);
        proj.setItem(bundleSrv.copy());
        return proj;
    }

    public void init(ItemStack carriedBundle, ItemStack sourceCrossbow) {
        BundleContents newContents;
        BundleContents contents;
        block12: {
            block11: {
                if (this.hasBeenInitialized) {
                    return;
                }
                this.hasBeenInitialized = true;
                if (ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, sourceCrossbow) > 0) break block11;
                Entity entity = this.getOwner();
                if (!(entity instanceof Player)) break block12;
                Player player = (Player)entity;
                if (!player.getAbilities().instabuild) break block12;
            }
            this.shouldDropOnHit = false;
        }
        if ((contents = (BundleContents)carriedBundle.get(DataComponents.BUNDLE_CONTENTS)) == null || contents.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> remain = new ArrayList<ItemStack>();
        AtomicInteger countdown = new AtomicInteger(0);
        int fireworkCount = 0;
        int otherCount = 0;
        for (ItemStack stack : contents.itemCopyStream().toList()) {
            if (stack.is(Items.FIREWORK_ROCKET)) {
                fireworkCount += stack.getCount();
                for (int i = 0; i < stack.getCount(); ++i) {
                    this.itemsToEject.addLast(new ItemToEject(countdown.addAndGet(BundleProjectile.lifeFor(stack)), stack.copy()));
                }
                continue;
            }
            otherCount += stack.getCount();
            remain.add(stack.copy());
        }
        if (!remain.isEmpty()) {
            newContents = new BundleContents(List.copyOf(remain));
            carriedBundle.set(DataComponents.BUNDLE_CONTENTS, (Object)newContents);
        } else {
            newContents = BundleContents.EMPTY;
            carriedBundle.set(DataComponents.BUNDLE_CONTENTS, (Object)newContents);
        }
        this.originalContents = newContents;
    }

    public void updateContents(BundleContents newContents) {
        ItemStack item = this.getItem();
        item.set(DataComponents.BUNDLE_CONTENTS, (Object)newContents);
        this.setItem(item);
        this.originalContents = newContents;
    }

    protected Item getDefaultItem() {
        return Items.BUNDLE;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (InfinityHelper.hasInfinitySource((Projectile)this)) {
                this.shouldDropOnHit = false;
            }
            ++this.lifetime;
            int modifiedMaxLifetime = 1200;
            modifiedMaxLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData());
            if (this.lifetime > (modifiedMaxLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedMaxLifetime, this.getPersistentData()))) {
                if (this.shouldDropOnHit) {
                    this.dropBundleAfterFire();
                }
                this.discard();
                return;
            }
            LeakyHelper.update(this, this.tickCount);
        }
        this.tickFirework();
        ++this.rocketAge;
    }

    private void tickFirework() {
        if (this.itemsToEject.isEmpty()) {
            return;
        }
        if (this.itemsToEject.peekFirst().countdown <= this.rocketAge) {
            ItemStack firework = this.itemsToEject.pollFirst().firework;
            Fireworks fw = (Fireworks)firework.get(DataComponents.FIREWORKS);
            List expl = !fw.explosions().isEmpty() ? fw.explosions() : List.of();
            this.level().createFireworks(this.getX(), this.getY(), this.getZ(), this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, expl);
            if (this.itemsToEject.isEmpty() && !this.level().isClientSide) {
                this.triggerAirburstExplosion(this.position(), 0.5f, 0.1f);
                if (this.shouldDropOnHit) {
                    this.dropBundleAfterFire();
                }
                this.discard();
            }
        }
        if (!this.horizontalCollision) {
            Vec3 v = this.getDeltaMovement();
            this.setDeltaMovement(v.multiply(1.01, 0.95, 1.01).add(0.0, 0.01, 0.0));
        }
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FIREWORK, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
            this.level().playSound((Entity)this, this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.AMBIENT, 1.5f, 1.0f);
        }
    }

    @Override
    protected void afterHitBlock(BlockHitResult blockHit) {
        int bounceLeft;
        if (this.isRemoved()) {
            return;
        }
        if (!this.level().isClientSide && (bounceLeft = this.getPersistentData().getIntOr("mafishcrossbow_bounceLeft", 0)) <= 0) {
            Vec3 shootDir = this.reflectDir(blockHit.getDirection().getUnitVec3());
            double verticalComponent = Math.abs(shootDir.y);
            if (verticalComponent > 0.985) {
                Vec3 normal = blockHit.getDirection().getUnitVec3();
                this.triggerHemisphereExplosion(normal, blockHit.getLocation(), 0.5f, 0.1f);
                if (!this.level().isClientSide && this.shouldDropOnHit) {
                    this.dropBundleAfterFire();
                }
                this.discard();
            } else {
                this.explodeAndCleanup(shootDir, blockHit.getLocation());
            }
        }
    }

    @Override
    protected void afterHitEntity(EntityHitResult entityHit) {
        int bounceLeft;
        if (this.isRemoved()) {
            return;
        }
        if (!this.level().isClientSide && (bounceLeft = this.getPersistentData().getIntOr("mafishcrossbow_bounceLeft", 0)) <= 0) {
            Vec3 normal = this.position().subtract(entityHit.getEntity().position()).normalize();
            Vec3 shootDir = this.reflectDir(normal);
            this.explodeAndCleanup(shootDir, entityHit.getEntity().position());
        }
    }

    private Vec3 reflectDir(Vec3 normal) {
        Vec3 incoming = this.getDeltaMovement().normalize();
        return incoming.subtract(normal.scale(2.0 * incoming.dot(normal)));
    }

    private void explodeAndCleanup(Vec3 baseDir, Vec3 hitPos) {
        this.triggerRandomExplosion(baseDir, hitPos, 0.5f, 0.1f);
        if (!this.level().isClientSide && this.shouldDropOnHit) {
            this.dropBundleAfterFire();
        }
        this.discard();
    }

    private static int lifeFor(ItemStack rocket) {
        Fireworks fw = (Fireworks)rocket.get(DataComponents.FIREWORKS);
        int flight = fw != null ? fw.flightDuration() : 0;
        return (flight + 1) * 4;
    }

    private void triggerRandomExplosion(Vec3 shootDir, Vec3 hitPos, float speedModify, float extraSpeed) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack bundle = this.getItem();
        BundleContents bundleContents = this.originalContents;
        if (bundleContents == null) {
            bundleContents = (BundleContents)bundle.get(DataComponents.BUNDLE_CONTENTS);
        }
        if (bundleContents == null || bundleContents.isEmpty()) {
            return;
        }
        List<ItemStack> contents = StreamSupport.stream(bundleContents.items().spliterator(), false).flatMap(s -> Stream.generate(() -> ((ItemStack)s).copy()).limit(s.getCount())).filter(s -> !s.isEmpty()).toList();
        double baseSpeed = 1.5f * speedModify + extraSpeed;
        RandomSource rand = this.level().random;
        for (ItemStack ammo : contents) {
            LivingEntity l;
            Entity least2;
            float yaw = (rand.nextFloat() - 0.5f) * 2.0f * 40.0f;
            float pitch = (rand.nextFloat() - 0.5f) * 2.0f * 40.0f;
            Vec3 fireDir = shootDir.yRot((float)Math.toRadians(yaw)).xRot((float)Math.toRadians(pitch)).normalize();
            double speed = baseSpeed * Mth.lerp((double)rand.nextDouble(), (double)0.8f, (double)1.25);
            boolean hasInfinitySource = InfinityHelper.hasInfinitySource((Projectile)this) || this.getPersistentData().getBooleanOr("mafishcrossbow_bore_burst_infinity", false);
            UUID turretUUID = null;
            String turretDimension = null;
            CompoundTag persistentData = this.getPersistentData();
            if (persistentData.getBooleanOr("turret_fired", false)) {
                if (persistentData.contains("turret_uuid_most") && persistentData.contains("turret_uuid_least")) {
                    long most = persistentData.getLong("turret_uuid_most").orElse(0L);
                    long least2 = persistentData.getLong("turret_uuid_least").orElse(0L);
                    turretUUID = new UUID(most, least2);
                }
                turretDimension = persistentData.getString("turret_dimension").orElse(null);
                MafishCrossbow.LOGGER.info("[Turret Ender Pearl] BundleProjectile\u4f20\u9012\u70ae\u53f0\u6807\u8bb0 - UUID: {}, \u7ef4\u5ea6: {}", turretUUID, (Object)turretDimension);
            }
            StaticShooterContext ctx = new StaticShooterContext(hitPos, fireDir, (least2 = this.getOwner()) instanceof LivingEntity ? (l = (LivingEntity)least2) : null, hasInfinitySource, turretUUID, turretDimension);
            Projectile proj = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(this.level(), ctx, bundle, ammo);
            if (proj == null) continue;
            proj.setPos(hitPos.x, hitPos.y, hitPos.z);
            proj.setDeltaMovement(fireDir.scale(speed));
            int bowLeftLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWLEFT, bundle);
            int bowRightLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWRIGHT, bundle);
            if (bowLeftLevel > 0 && bowRightLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, -15.0f);
                proj.setDeltaMovement(rotatedMotion);
            } else if (bowRightLevel > 0 && bowLeftLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, 15.0f);
                proj.setDeltaMovement(rotatedMotion);
            }
            this.level().addFreshEntity((Entity)proj);
            if (ammo.isEmpty() || this.getItem().isEmpty()) continue;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)proj, (CustomPacketPayload)new BundleProjectileS2CPacket(ammo, this.getItem(), proj.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void triggerHemisphereExplosion(Vec3 normal, Vec3 hitPos, float speedModify, float extraSpeed) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack bundle = this.getItem();
        BundleContents bundleContents = this.originalContents;
        if (bundleContents == null) {
            bundleContents = (BundleContents)bundle.get(DataComponents.BUNDLE_CONTENTS);
        }
        if (bundleContents == null || bundleContents.isEmpty()) {
            return;
        }
        List<ItemStack> contents = StreamSupport.stream(bundleContents.items().spliterator(), false).flatMap(s -> Stream.generate(() -> ((ItemStack)s).copy()).limit(s.getCount())).filter(s -> !s.isEmpty()).toList();
        RandomSource rand = this.level().random;
        double baseSpeed = 1.5f * speedModify + extraSpeed;
        for (ItemStack ammo : contents) {
            LivingEntity l;
            Vec3 fireDir = null;
            while (fireDir == null) {
                double invLength;
                Vec3 candidateDir;
                double z;
                double y;
                double x = rand.nextDouble() * 2.0 - 1.0;
                double lengthSquared = x * x + (y = rand.nextDouble() * 2.0 - 1.0) * y + (z = rand.nextDouble() * 2.0 - 1.0) * z;
                if (lengthSquared > 1.0 || lengthSquared < 0.01 || !((candidateDir = new Vec3(x * (invLength = 1.0 / Math.sqrt(lengthSquared)), y * invLength, z * invLength)).dot(normal) > 0.0)) continue;
                fireDir = candidateDir;
            }
            double speed = baseSpeed * Mth.lerp((double)rand.nextDouble(), (double)0.8f, (double)1.25);
            boolean hasInfinitySource = InfinityHelper.hasInfinitySource((Projectile)this) || this.getPersistentData().getBooleanOr("mafishcrossbow_bore_burst_infinity", false);
            Entity entity = this.getOwner();
            StaticShooterContext ctx = new StaticShooterContext(hitPos, fireDir, entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null, hasInfinitySource);
            Projectile proj = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(this.level(), ctx, bundle, ammo);
            if (proj == null) continue;
            proj.setPos(hitPos.x, hitPos.y, hitPos.z);
            proj.setDeltaMovement(fireDir.scale(speed));
            int bowLeftLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWLEFT, bundle);
            int bowRightLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWRIGHT, bundle);
            if (bowLeftLevel > 0 && bowRightLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, -15.0f);
                proj.setDeltaMovement(rotatedMotion);
            } else if (bowRightLevel > 0 && bowLeftLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, 15.0f);
                proj.setDeltaMovement(rotatedMotion);
            }
            this.level().addFreshEntity((Entity)proj);
            if (ammo.isEmpty() || this.getItem().isEmpty()) continue;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)proj, (CustomPacketPayload)new BundleProjectileS2CPacket(ammo, this.getItem(), proj.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void triggerAirburstExplosion(Vec3 center, float speedModify, float extraSpeed) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack bundle = this.getItem();
        BundleContents bundleContents = this.originalContents;
        if (bundleContents == null) {
            bundleContents = (BundleContents)bundle.get(DataComponents.BUNDLE_CONTENTS);
        }
        if (bundleContents == null || bundleContents.isEmpty()) {
            return;
        }
        List<ItemStack> contents = StreamSupport.stream(bundleContents.items().spliterator(), false).flatMap(s -> Stream.generate(() -> ((ItemStack)s).copy()).limit(s.getCount())).filter(s -> !s.isEmpty()).toList();
        RandomSource rand = this.level().random;
        double baseSpeed = 1.5f * speedModify + extraSpeed;
        for (ItemStack ammo : contents) {
            LivingEntity l;
            double z;
            double y;
            double x;
            double lengthSquared;
            while ((lengthSquared = (x = rand.nextDouble() * 2.0 - 1.0) * x + (y = rand.nextDouble() * 2.0 - 1.0) * y + (z = rand.nextDouble() * 2.0 - 1.0) * z) > 1.0 || lengthSquared < 0.01) {
            }
            double invLength = 1.0 / Math.sqrt(lengthSquared);
            Vec3 fireDir = new Vec3(x * invLength, y * invLength, z * invLength);
            double speed = baseSpeed * Mth.lerp((double)rand.nextDouble(), (double)0.8f, (double)1.25);
            boolean hasInfinitySource = InfinityHelper.hasInfinitySource((Projectile)this) || this.getPersistentData().getBooleanOr("mafishcrossbow_bore_burst_infinity", false);
            Entity entity = this.getOwner();
            StaticShooterContext ctx = new StaticShooterContext(center, fireDir, entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null, hasInfinitySource);
            Projectile proj = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(this.level(), ctx, bundle, ammo);
            if (proj == null) continue;
            proj.setPos(center.x, center.y, center.z);
            proj.setDeltaMovement(fireDir.scale(speed));
            int bowLeftLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWLEFT, bundle);
            int bowRightLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWRIGHT, bundle);
            if (bowLeftLevel > 0 && bowRightLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, -15.0f);
                proj.setDeltaMovement(rotatedMotion);
            } else if (bowRightLevel > 0 && bowLeftLevel == 0) {
                motion = proj.getDeltaMovement();
                rotatedMotion = this.rotateYaw(motion, 15.0f);
                proj.setDeltaMovement(rotatedMotion);
            }
            this.level().addFreshEntity((Entity)proj);
            if (ammo.isEmpty() || this.getItem().isEmpty()) continue;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)proj, (CustomPacketPayload)new BundleProjectileS2CPacket(ammo, this.getItem(), proj.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void dropBundleAfterFire() {
        ItemStack original = this.getItem();
        if (original.isEmpty()) {
            return;
        }
        ItemStack dropped = original.copy();
        dropped.set(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), dropped));
    }

    private Vec3 rotateYaw(Vec3 vec, float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        double newX = vec.x * (double)cos - vec.z * (double)sin;
        double newZ = vec.x * (double)sin + vec.z * (double)cos;
        return new Vec3(newX, vec.y, newZ);
    }

    protected void addAdditionalSaveData(ValueOutput out) {
        super.addAdditionalSaveData(out);
        ItemStack itemToSave = this.getItem();
        if (itemToSave.isEmpty()) {
            itemToSave = new ItemStack((ItemLike)Items.BUNDLE);
        }
        out.store(TAG_BUNDLE, ItemStack.CODEC, (Object)itemToSave);
        if (this.originalContents != null) {
            out.store(TAG_BUNDLE_CONTENTS, BundleContents.CODEC, (Object)this.originalContents);
        } else {
            BundleContents bundleContents = (BundleContents)itemToSave.get(DataComponents.BUNDLE_CONTENTS);
            if (bundleContents != null) {
                out.store(TAG_BUNDLE_CONTENTS, BundleContents.CODEC, (Object)bundleContents);
            }
        }
        out.putBoolean(TAG_DROP, this.shouldDropOnHit);
        out.putInt(TAG_ROCKET_AGE, this.rocketAge);
        out.putInt(TAG_LIFETIME, this.lifetime);
        out.putBoolean(TAG_INITIALIZED, this.hasBeenInitialized);
        ValueOutput.ValueOutputList list = out.childrenList(TAG_EJECT_QUEUE);
        for (ItemToEject item : this.itemsToEject) {
            ValueOutput entry = list.addChild();
            entry.putInt("Countdown", item.countdown());
            entry.store("Firework", ItemStack.CODEC, (Object)item.firework());
        }
    }

    protected void readAdditionalSaveData(ValueInput in) {
        Optional backupContents;
        ItemStack bundle = in.read(TAG_BUNDLE, ItemStack.CODEC).orElse(new ItemStack((ItemLike)Items.BUNDLE));
        if (bundle.isEmpty()) {
            bundle = new ItemStack((ItemLike)Items.BUNDLE);
        }
        if ((backupContents = in.read(TAG_BUNDLE_CONTENTS, BundleContents.CODEC)).isPresent()) {
            this.originalContents = (BundleContents)backupContents.get();
            bundle.set(DataComponents.BUNDLE_CONTENTS, (Object)this.originalContents);
        }
        super.readAdditionalSaveData(in);
        this.setItem(bundle);
        this.shouldDropOnHit = in.getBooleanOr(TAG_DROP, true);
        this.rocketAge = in.getIntOr(TAG_ROCKET_AGE, 0);
        this.lifetime = in.getIntOr(TAG_LIFETIME, 0);
        this.hasBeenInitialized = in.getBooleanOr(TAG_INITIALIZED, false);
        this.itemsToEject.clear();
        in.childrenList(TAG_EJECT_QUEUE).ifPresent(list -> {
            for (ValueInput entry : list) {
                int countdown = entry.getIntOr("Countdown", 0);
                ItemStack firework = entry.read("Firework", ItemStack.CODEC).orElse(ItemStack.EMPTY);
                this.itemsToEject.add(new ItemToEject(countdown, firework));
            }
        });
    }

    private record ItemToEject(int countdown, ItemStack firework) {
    }
}

