/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.google.common.collect.Lists;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CustomShulkerBulletEntity
extends Projectile {
    private static final double SPEED = 0.15;
    private static final int MAX_LIFE_TIME = 600;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    private int lifeTicks;
    private float baseDamage = 4.0f;

    public CustomShulkerBulletEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public CustomShulkerBulletEntity(EntityType<? extends Projectile> entityType, Level level, LivingEntity shooter, @Nullable Entity target) {
        this(entityType, level);
        this.setOwner((Entity)shooter);
        Vec3 shooterPos = shooter.getEyePosition();
        this.setPos(shooterPos.x, shooterPos.y, shooterPos.z);
        if (target != null) {
            this.finalTarget = target;
            this.targetUUID = target.getUUID();
        } else {
            this.finalTarget = this.selectTargetHybrid(shooter);
            if (this.finalTarget != null) {
                this.targetUUID = this.finalTarget.getUUID();
            }
        }
        this.currentMoveDirection = Direction.UP;
        if (this.finalTarget != null) {
            this.selectNextMoveDirection(Direction.Axis.Y);
        }
    }

    @Nullable
    private Entity selectTargetHybrid(LivingEntity shooter) {
        Vec3 lookVec;
        Vec3 endPos;
        Vec3 eyePos;
        Level level = shooter.level();
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)level, (Projectile)this, (Vec3)(eyePos = shooter.getEyePosition()), (Vec3)(endPos = eyePos.add((lookVec = shooter.getLookAngle()).scale(64.0))), (AABB)shooter.getBoundingBox().expandTowards(lookVec.scale(64.0)).inflate(1.0), entity -> !entity.isSpectator() && entity.isAlive() && this.isValidTarget(shooter, (Entity)entity));
        if (entityHit != null && entityHit.getEntity() instanceof LivingEntity) {
            return entityHit.getEntity();
        }
        AABB searchBox = shooter.getBoundingBox().inflate(32.0);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, searchBox, entity -> entity.isAlive() && this.isValidTarget(shooter, (Entity)entity));
        if (nearbyEntities.isEmpty()) {
            return null;
        }
        LivingEntity bestTarget = null;
        double bestAlignment = -1.0;
        for (LivingEntity entity2 : nearbyEntities) {
            Vec3 toEntity = entity2.getEyePosition().subtract(eyePos).normalize();
            double alignment = lookVec.dot(toEntity);
            if (!(alignment > 0.5) || !(alignment > bestAlignment)) continue;
            bestAlignment = alignment;
            bestTarget = entity2;
        }
        return bestTarget;
    }

    private boolean isValidTarget(LivingEntity shooter, Entity target) {
        if (target == shooter) {
            return false;
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (targetPlayer.isCreative() || targetPlayer.isSpectator()) {
                return false;
            }
            if (shooter instanceof Player) {
                Player shooterPlayer = (Player)shooter;
                return true;
            }
        }
        if (target instanceof Enemy) {
            return true;
        }
        if (target instanceof Mob) {
            return true;
        }
        return target instanceof LivingEntity;
    }

    public void tick() {
        super.tick();
        ++this.lifeTicks;
        if (this.lifeTicks > 600) {
            this.discard();
            return;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
            return;
        }
        if (!this.level().isClientSide) {
            Player player;
            ServerLevel serverLevel;
            Entity entity;
            Level level;
            if (this.finalTarget == null && this.targetUUID != null && (level = this.level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.targetUUID)) instanceof LivingEntity) {
                this.finalTarget = entity;
            }
            if (this.finalTarget != null && (!this.finalTarget.isAlive() || (entity = this.finalTarget) instanceof Player && (player = (Player)entity).isSpectator())) {
                this.finalTarget = null;
                this.targetUUID = null;
            }
            if (this.finalTarget == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
            } else {
                this.targetDeltaX = Mth.clamp((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = Mth.clamp((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = Mth.clamp((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                Vec3 currentVelocity = this.getDeltaMovement();
                this.setDeltaMovement(currentVelocity.add((this.targetDeltaX - currentVelocity.x) * 0.2, (this.targetDeltaY - currentVelocity.y) * 0.2, (this.targetDeltaZ - currentVelocity.z) * 0.2));
            }
        }
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        Vec3 velocity = this.getDeltaMovement();
        this.setPos(this.position().add(velocity));
        if (hitResult != null && hitResult.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf(hitResult);
        }
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.5f);
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX() - velocity.x, this.getY() - velocity.y + 0.15, this.getZ() - velocity.z, 0.0, 0.0, 0.0);
        } else if (this.finalTarget != null) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.getAxis());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos currentPos = this.blockPosition();
                Direction.Axis axis = this.currentMoveDirection.getAxis();
                if (this.level().loadedAndEntityCanStandOn(currentPos.relative(this.currentMoveDirection), (Entity)this)) {
                    this.selectNextMoveDirection(axis);
                } else {
                    BlockPos targetPos = this.finalTarget.blockPosition();
                    if (axis == Direction.Axis.X && currentPos.getX() == targetPos.getX() || axis == Direction.Axis.Z && currentPos.getZ() == targetPos.getZ() || axis == Direction.Axis.Y && currentPos.getY() == targetPos.getY()) {
                        this.selectNextMoveDirection(axis);
                    }
                }
            }
        }
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis restrictedAxis) {
        BlockPos targetPos;
        double centerOffset = 0.5;
        if (this.finalTarget == null) {
            targetPos = this.blockPosition().below();
        } else {
            centerOffset = (double)this.finalTarget.getBbHeight() * 0.5;
            targetPos = BlockPos.containing((double)this.finalTarget.getX(), (double)(this.finalTarget.getY() + centerOffset), (double)this.finalTarget.getZ());
        }
        double targetX = (double)targetPos.getX() + 0.5;
        double targetY = (double)targetPos.getY() + centerOffset;
        double targetZ = (double)targetPos.getZ() + 0.5;
        Direction selectedDirection = null;
        if (!targetPos.closerToCenterThan((Position)this.position(), 2.0)) {
            BlockPos currentPos = this.blockPosition();
            ArrayList possibleDirections = Lists.newArrayList();
            if (restrictedAxis != Direction.Axis.X) {
                if (currentPos.getX() < targetPos.getX() && this.level().isEmptyBlock(currentPos.east())) {
                    possibleDirections.add(Direction.EAST);
                } else if (currentPos.getX() > targetPos.getX() && this.level().isEmptyBlock(currentPos.west())) {
                    possibleDirections.add(Direction.WEST);
                }
            }
            if (restrictedAxis != Direction.Axis.Y) {
                if (currentPos.getY() < targetPos.getY() && this.level().isEmptyBlock(currentPos.above())) {
                    possibleDirections.add(Direction.UP);
                } else if (currentPos.getY() > targetPos.getY() && this.level().isEmptyBlock(currentPos.below())) {
                    possibleDirections.add(Direction.DOWN);
                }
            }
            if (restrictedAxis != Direction.Axis.Z) {
                if (currentPos.getZ() < targetPos.getZ() && this.level().isEmptyBlock(currentPos.south())) {
                    possibleDirections.add(Direction.SOUTH);
                } else if (currentPos.getZ() > targetPos.getZ() && this.level().isEmptyBlock(currentPos.north())) {
                    possibleDirections.add(Direction.NORTH);
                }
            }
            selectedDirection = Direction.getRandom((RandomSource)this.random);
            if (possibleDirections.isEmpty()) {
                for (int i = 5; !this.level().isEmptyBlock(currentPos.relative(selectedDirection)) && i > 0; --i) {
                    selectedDirection = Direction.getRandom((RandomSource)this.random);
                }
            } else {
                selectedDirection = (Direction)possibleDirections.get(this.random.nextInt(possibleDirections.size()));
            }
            targetX = this.getX() + (double)selectedDirection.getStepX();
            targetY = this.getY() + (double)selectedDirection.getStepY();
            targetZ = this.getZ() + (double)selectedDirection.getStepZ();
        }
        this.setMoveDirection(selectedDirection);
        double deltaX = targetX - this.getX();
        double deltaY = targetY - this.getY();
        double deltaZ = targetZ - this.getZ();
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        if (distance == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = deltaX / distance * 0.15;
            this.targetDeltaY = deltaY / distance * 0.15;
            this.targetDeltaZ = deltaZ / distance * 0.15;
        }
        this.hasImpulse = true;
        this.flightSteps = 10 + this.random.nextInt(5) * 10;
    }

    private void setMoveDirection(@Nullable Direction direction) {
        this.currentMoveDirection = direction;
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity target = result.getEntity();
        Entity owner = this.getOwner();
        LivingEntity livingOwner = owner instanceof LivingEntity ? (LivingEntity)owner : null;
        DamageSource damageSource = this.damageSources().mobProjectile((Entity)this, livingOwner);
        float finalDamage = IncreaseDamageHelper.modifyDamage(this.baseDamage, this.getPersistentData());
        finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
        target.hurt(damageSource, finalDamage);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200), (Entity)(owner != null ? owner : this));
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        }
        this.playSound(SoundEvents.SHULKER_BULLET_HIT, 1.0f, 1.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.discard();
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float damage) {
        this.playSound(SoundEvents.SHULKER_BULLET_HURT, 1.0f, 1.0f);
        level.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 15, 0.2, 0.2, 0.2, 0.0);
        this.discard();
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.targetUUID != null) {
            output.store("Target", UUIDUtil.CODEC, (Object)this.targetUUID);
        }
        output.storeNullable("Dir", Direction.LEGACY_ID_CODEC, (Object)this.currentMoveDirection);
        output.putInt("Steps", this.flightSteps);
        output.putDouble("TXD", this.targetDeltaX);
        output.putDouble("TYD", this.targetDeltaY);
        output.putDouble("TZD", this.targetDeltaZ);
        output.putInt("LifeTicks", this.lifeTicks);
        output.putFloat("BaseDamage", this.baseDamage);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        input.read("Target", UUIDUtil.CODEC).ifPresent(uuid -> {
            this.targetUUID = uuid;
        });
        this.currentMoveDirection = input.read("Dir", Direction.LEGACY_ID_CODEC).orElse(null);
        this.flightSteps = input.getIntOr("Steps", 0);
        this.targetDeltaX = input.getDoubleOr("TXD", 0.0);
        this.targetDeltaY = input.getDoubleOr("TYD", 0.0);
        this.targetDeltaZ = input.getDoubleOr("TZD", 0.0);
        this.lifeTicks = input.getIntOr("LifeTicks", 0);
        this.baseDamage = input.getFloatOr("BaseDamage", 4.0f);
    }

    public void setBaseDamage(float damage) {
        this.baseDamage = damage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }
}

