/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreasedamage.DecreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increasedamage.IncreaseDamageHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EchoShardProjectile
extends TrailEntity {
    private static final float SONIC_DAMAGE = 4.0f;
    private static final double SONIC_RANGE = 1.0;
    private static final int DEFAULT_LIFETIME = 6;
    private static final int HIT_COOLDOWN = 15;
    private int sonicTickCount = 0;
    private int maxLifetime = 6;
    private final Map<Integer, Integer> hitCooldowns = new HashMap<Integer, Integer>();
    private Vec3 launchPosition;

    public EchoShardProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public EchoShardProjectile(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity owner, Level level, ItemStack item, Vec3 startPos) {
        super(entityType, owner, level, item);
        this.setNoGravity(true);
        this.setPos(startPos);
        this.launchPosition = startPos;
    }

    protected Item getDefaultItem() {
        return Items.ECHO_SHARD;
    }

    public void setMaxLifetime(int lifetime) {
        this.maxLifetime = Math.max(1, lifetime);
    }

    public static int getDefaultLifetime() {
        return 6;
    }

    public static int getHitCooldown() {
        return 15;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.sonicTickCount == 0 && !this.level().isClientSide) {
            int baseLifetime;
            int modifiedLifetime = baseLifetime = 6;
            modifiedLifetime = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedLifetime, this.getPersistentData());
            this.maxLifetime = modifiedLifetime = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, modifiedLifetime, this.getPersistentData());
        }
        ++this.sonicTickCount;
        if (!this.level().isClientSide) {
            this.hitCooldowns.entrySet().removeIf(entry -> {
                entry.setValue((Integer)entry.getValue() - 1);
                return (Integer)entry.getValue() <= 0;
            });
            this.spawnSonicParticles();
            this.damageEntitiesInPath();
            if (this.sonicTickCount > this.maxLifetime) {
                this.discard();
            }
        }
        if (this.sonicTickCount % 5 == 0 && this.launchPosition != null) {
            this.level().playSound(null, this.launchPosition.x, this.launchPosition.y, this.launchPosition.z, SoundEvents.WARDEN_SONIC_BOOM, SoundSource.HOSTILE, 0.3f, 1.5f);
        }
    }

    private void spawnSonicParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 currentPos = this.position();
            Vec3 prevPos = new Vec3(this.xOld, this.yOld, this.zOld);
            Vec3 direction = currentPos.subtract(prevPos).normalize();
            double distance = currentPos.distanceTo(prevPos);
            int particleCount = Math.max(1, (int)(distance / 0.5) + 1);
            for (int i = 0; i < particleCount; ++i) {
                double t = (double)i / (double)particleCount;
                Vec3 particlePos = prevPos.lerp(currentPos, t);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, true, false, particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.0);
                if (i % 3 != 0) continue;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, true, false, particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void damageEntitiesInPath() {
        Vec3 currentPos = this.position();
        Vec3 prevPos = new Vec3(this.xOld, this.yOld, this.zOld);
        double distance = currentPos.distanceTo(prevPos);
        int checkPoints = Math.max(1, (int)(distance / 0.5) + 1);
        for (int i = 0; i < checkPoints; ++i) {
            double t = (double)i / (double)(checkPoints - 1);
            Vec3 checkPos = prevPos.lerp(currentPos, t);
            AABB damageBounds = new AABB(checkPos.x - 1.0, checkPos.y - 1.0, checkPos.z - 1.0, checkPos.x + 1.0, checkPos.y + 1.0, checkPos.z + 1.0);
            List entities = this.level().getEntities((Entity)this, damageBounds);
            for (Entity entity : entities) {
                int entityId;
                if (!(entity instanceof LivingEntity) || entity == this.getOwner() || this.hitCooldowns.containsKey(entityId = entity.getId())) continue;
                this.hitCooldowns.put(entityId, 15);
                float baseDamage = 4.0f;
                float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
                finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
                entity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), finalDamage);
                Vec3 knockbackDir = entity.position().subtract(this.position()).normalize();
                entity.setDeltaMovement(entity.getDeltaMovement().add(knockbackDir.x * 0.5, 0.2, knockbackDir.z * 0.5));
            }
        }
    }

    @Override
    protected void afterHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide) {
            this.createSonicExplosion(result.getLocation());
            this.knockbackNearbyEntities(result.getLocation());
            this.discard();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        int entityId;
        if (!this.level().isClientSide && !this.hitCooldowns.containsKey(entityId = (entity = result.getEntity()).getId())) {
            this.hitCooldowns.put(entityId, 15);
            float baseDamage = 8.0f;
            float finalDamage = IncreaseDamageHelper.modifyDamage(baseDamage, this.getPersistentData());
            finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
            entity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), finalDamage);
            Vec3 knockbackDir = entity.position().subtract(this.position()).normalize();
            entity.setDeltaMovement(entity.getDeltaMovement().add(knockbackDir.x * 1.0, 0.4, knockbackDir.z * 1.0));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, true, false, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 5, 0.1, 0.1, 0.1, 0.03);
            }
        }
    }

    private void createSonicExplosion(Vec3 location) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, true, false, location.x, location.y, location.z, 15, 0.3, 0.3, 0.3, 0.05);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, true, false, location.x, location.y, location.z, 8, 0.2, 0.2, 0.2, 0.03);
            if (this.launchPosition != null) {
                this.level().playSound(null, this.launchPosition.x, this.launchPosition.y, this.launchPosition.z, SoundEvents.WARDEN_SONIC_BOOM, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    private void knockbackNearbyEntities(Vec3 center) {
        double knockbackRange = 3.0;
        AABB knockbackBounds = new AABB(center.x - knockbackRange, center.y - knockbackRange, center.z - knockbackRange, center.x + knockbackRange, center.y + knockbackRange, center.z + knockbackRange);
        List entities = this.level().getEntities((Entity)this, knockbackBounds);
        for (Entity entity : entities) {
            double distance;
            double knockbackStrength;
            if (!(entity instanceof LivingEntity) || entity == this.getOwner() || !((knockbackStrength = 1.0 - (distance = entity.position().distanceTo(center)) / knockbackRange) > 0.0)) continue;
            Vec3 knockbackDir = entity.position().subtract(center).normalize();
            entity.setDeltaMovement(entity.getDeltaMovement().add(knockbackDir.x * knockbackStrength * 1.5, knockbackStrength * 0.5, knockbackDir.z * knockbackStrength * 1.5));
            float damageAmount = (float)(4.0 * knockbackStrength);
            float finalDamage = IncreaseDamageHelper.modifyDamage(damageAmount, this.getPersistentData());
            finalDamage = DecreaseDamageHelper.modifyDamage(finalDamage, this.getPersistentData());
            entity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), finalDamage);
        }
    }
}

